/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SingleItemRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gems.init.GemsRecipeInit;

public class AltarTransmutationRecipe
extends SingleItemRecipe {
    public static final IRecipeType<AltarTransmutationRecipe> RECIPE_TYPE = new IRecipeType<AltarTransmutationRecipe>(){

        public String toString() {
            return "silentgems:altar_transmutation";
        }
    };
    private final Ingredient catalyst;
    private int chaosGenerated = 5000;
    private int processTime = 200;

    public AltarTransmutationRecipe(ResourceLocation id, Ingredient ingredient, Ingredient catalyst, ItemStack result) {
        super(RECIPE_TYPE, (IRecipeSerializer)GemsRecipeInit.ALTAR_TRANSMUTATION.get(), id, "", ingredient, result);
        this.catalyst = catalyst;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack inputItem = inv.func_70301_a(0);
        ItemStack catalystItem = inv.func_70301_a(1);
        return this.field_222131_a.test(inputItem) && this.catalyst.test(catalystItem);
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.field_222131_a);
        list.add((Object)this.catalyst);
        return list;
    }

    public Ingredient getIngredient() {
        return this.field_222131_a;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public int getChaosGenerated() {
        return this.chaosGenerated;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AltarTransmutationRecipe> {
        public AltarTransmutationRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            Ingredient catalyst = Ingredient.func_199802_a((JsonElement)json.get("catalyst"));
            ItemStack resultStack = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("result"));
            AltarTransmutationRecipe recipe = new AltarTransmutationRecipe(recipeId, ingredient, catalyst, resultStack);
            recipe.chaosGenerated = JSONUtils.func_151208_a((JsonObject)json, (String)"chaosGenerated", (int)recipe.chaosGenerated);
            recipe.processTime = JSONUtils.func_151208_a((JsonObject)json, (String)"processTime", (int)recipe.processTime);
            return recipe;
        }

        public AltarTransmutationRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient catalyst = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            AltarTransmutationRecipe recipe = new AltarTransmutationRecipe(recipeId, ingredient, catalyst, result);
            recipe.chaosGenerated = buffer.func_150792_a();
            recipe.processTime = buffer.func_150792_a();
            return recipe;
        }

        public void write(PacketBuffer buffer, AltarTransmutationRecipe recipe) {
            recipe.field_222131_a.func_199564_a(buffer);
            recipe.catalyst.func_199564_a(buffer);
            buffer.func_150788_a(recipe.field_222132_b);
            buffer.func_150787_b(recipe.chaosGenerated);
            buffer.func_150787_b(recipe.processTime);
        }
    }
}

