/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.crafting.recipe;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gems.init.GemsRecipeInit;
import net.silentchaos512.gems.item.ChaosGemItem;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.lib.collection.StackList;

public class ApplyChaosRuneRecipe
extends SpecialRecipe {
    public ApplyChaosRuneRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack chaosGem = list.uniqueOfType(ChaosGemItem.class);
        int runes = list.countOfType(ChaosRuneItem.class);
        return !chaosGem.func_190926_b() && runes > 0;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack chaosGem = ItemStack.field_190927_a;
        NonNullList runes = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ChaosRuneItem) {
                runes.add(stack);
                continue;
            }
            if (!chaosGem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            chaosGem = stack;
        }
        if (chaosGem.func_190926_b() || runes.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = chaosGem.func_77946_l();
        for (ItemStack rune : runes) {
            IChaosBuff buff = ChaosRuneItem.getBuff(rune);
            if (buff != null && ChaosGemItem.addBuff(result, buff)) continue;
            return ItemStack.field_190927_a;
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)GemsRecipeInit.APPLY_CHAOS_RUNE.get();
    }
}

