/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.lib.advancements.GenericIntTrigger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GemsAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public GemsAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = GemsAdvancementProvider.getPath(path, p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new Advancements().accept(consumer);
    }

    public String func_200397_b() {
        return "Silent's Gems - Advancements";
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    private static class Advancements
    implements Consumer<Consumer<Advancement>> {
        private Advancements() {
        }

        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement root = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)Gems.ALEXANDRITE.getItem(), Advancements.title("root"), Advancements.description("root"), new ResourceLocation("minecraft:textures/gui/advancements/backgrounds/adventure.png"), FrameType.TASK, false, false, false).func_200275_a("get_item", Advancements.getItem(new IItemProvider[]{Items.field_221734_cc})).func_203904_a(consumer, Advancements.id("root"));
            Advancement getGems = Advancements.simpleGetItem(consumer, GemsTags.Items.GEMS, (IItemProvider)Gems.RUBY.getItem(), root, "gem");
            for (Gems.Set set : Gems.Set.values()) {
                String name = "all_gems_" + set.getName();
                Advancement.Builder builder = Advancement.Builder.func_200278_a().func_203905_a(getGems).func_203902_a((IItemProvider)set.getSetIcon().getItem(), Advancements.title(name), Advancements.description(name), null, FrameType.CHALLENGE, true, true, false);
                for (Gems gem : set) {
                    builder.func_200275_a(gem.getName(), Advancements.getItem(new IItemProvider[]{gem.getItem()}));
                }
                builder.func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id(name));
            }
            Advancement chaosCrystal = Advancements.simpleGetItem(consumer, CraftingItems.CHAOS_CRYSTAL, root, "chaos_crystal");
            Advancement chaosIron = Advancement.Builder.func_200278_a().func_203905_a(chaosCrystal).func_203902_a((IItemProvider)CraftingItems.CHAOS_IRON_INGOT, Advancements.title("chaos_iron"), Advancements.description("chaos_iron"), null, FrameType.TASK, true, true, false).func_200275_a("get_dust", Advancements.getItem(CraftingItems.CHAOS_IRON_DUST)).func_200275_a("get_ingot", Advancements.getItem(CraftingItems.CHAOS_IRON_INGOT)).func_203904_a(consumer, Advancements.id("chaos_iron"));
            Advancement teleporterAnchor = Advancements.simpleGetItem(consumer, GemsBlocks.TELEPORTER_ANCHOR, chaosCrystal, "teleporter_anchor");
            Advancement returnHomeCharm = Advancements.simpleGetItem(consumer, GemsTags.Items.RETURN_HOME_CHARMS, (IItemProvider)Gems.AMETHYST.getReturnHomeCharm(), teleporterAnchor, "return_home_charm");
            Advancement tokenEnchanter = Advancements.simpleGetItem(consumer, GemsBlocks.TOKEN_ENCHANTER, chaosIron, "token_enchanter");
            Advancement enchantmentToken = Advancements.simpleGetItem(consumer, GemsItems.ENCHANTMENT_TOKEN, tokenEnchanter, "enchantment_token");
            Advancement enrichedChaos = Advancements.simpleGetItem(consumer, CraftingItems.ENRICHED_CHAOS_CRYSTAL, tokenEnchanter, "enriched_chaos");
            Advancement chaosMeter = Advancements.simpleGetItem(consumer, GemsItems.CHAOS_METER, enrichedChaos, "chaos_meter");
            Advancement transmutationAltar = Advancements.simpleGetItem(consumer, GemsBlocks.TRANSMUTATION_ALTAR, enrichedChaos, "transmutation_altar");
            Advancement transmutationCrystals = Advancement.Builder.func_200278_a().func_203905_a(transmutationAltar).func_203902_a((IItemProvider)CraftingItems.MAGMA_CREAM_CRYSTAL, Advancements.title("transmutation_crystals"), Advancements.description("transmutation_crystals"), null, FrameType.GOAL, true, true, false).func_200275_a("slime", Advancements.getItem(CraftingItems.SLIME_CRYSTAL)).func_200275_a("magma", Advancements.getItem(CraftingItems.MAGMA_CREAM_CRYSTAL)).func_200275_a("ender", Advancements.getItem(CraftingItems.ENDER_SLIME_CRYSTAL)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("transmutation_crystals"));
            Advancement supercharger = Advancements.simpleGetItem(consumer, GemsBlocks.SUPERCHARGER, chaosIron, "supercharger");
            Advancement superchargerPillar1 = Advancement.Builder.func_200278_a().func_203905_a(supercharger).func_203902_a((IItemProvider)CraftingItems.CHARGING_AGENT, Advancements.title("supercharger_pillar1"), Advancements.description("supercharger_pillar1"), null, FrameType.TASK, true, true, false).func_200275_a("get_charging_agent", Advancements.getItem(CraftingItems.CHARGING_AGENT)).func_200275_a("get_caps", Advancements.getItem(GemsTags.Items.SUPERCHARGER_PILLAR_CAP, 4)).func_200275_a("get_bases", Advancements.getItem(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, 4)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("supercharger_pillar1"));
            Advancement superchargerPillar2 = Advancement.Builder.func_200278_a().func_203905_a(superchargerPillar1).func_203902_a((IItemProvider)CraftingItems.SUPER_CHARGING_AGENT, Advancements.title("supercharger_pillar2"), Advancements.description("supercharger_pillar2"), null, FrameType.TASK, true, true, false).func_200275_a("get_charging_agent", Advancements.getItem(CraftingItems.SUPER_CHARGING_AGENT)).func_200275_a("get_bases", Advancements.getItem(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL2, 4)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("supercharger_pillar2"));
            Advancement superchargerPillar3 = Advancement.Builder.func_200278_a().func_203905_a(superchargerPillar2).func_203902_a((IItemProvider)CraftingItems.ULTRA_CHARGING_AGENT, Advancements.title("supercharger_pillar3"), Advancements.description("supercharger_pillar3"), null, FrameType.CHALLENGE, true, true, false).func_200275_a("get_charging_agent", Advancements.getItem(CraftingItems.SUPER_CHARGING_AGENT)).func_200275_a("get_bases", Advancements.getItem(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL3, 4)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("supercharger_pillar3"));
            Advancement pedestal = Advancements.simpleGetItem(consumer, GemsTags.Items.PEDESTALS, GemsBlocks.STONE_PEDESTAL, enrichedChaos, "pedestal");
            Advancement chaosOrbOnPedestal = Advancement.Builder.func_200278_a().func_203905_a(pedestal).func_203902_a(GemsItems.PERFECT_CHAOS_ORB, Advancements.title("chaos_orb_on_pedestal"), Advancements.description("chaos_orb_on_pedestal"), null, FrameType.GOAL, true, true, false).func_200275_a("place", (ICriterionInstance)Advancements.placedBlockWithItem(ItemPredicate.Builder.func_200309_a().func_200307_a(GemsTags.Items.CHAOS_ORBS).func_200310_b())).func_203904_a(consumer, Advancements.id("chaos_orb_on_pedestal"));
            Advancement chaosGem = Advancement.Builder.func_200278_a().func_203905_a(enrichedChaos).func_203902_a((IItemProvider)Gems.GREEN_SAPPHIRE.getChaosGem(), Advancements.title("chaos_gem"), Advancements.description("chaos_gem"), null, FrameType.TASK, true, true, false).func_200275_a("get_gem", Advancements.getItem(GemsTags.Items.CHAOS_GEMS)).func_200275_a("get_rune", Advancements.getItem(new IItemProvider[]{GemsItems.CHAOS_RUNE})).func_203904_a(consumer, Advancements.id("chaos_gem"));
            Advancement chaosGemOnPedestal = Advancement.Builder.func_200278_a().func_203905_a(chaosGem).func_203902_a((IItemProvider)Gems.TANZANITE.getChaosGem(), Advancements.title("chaos_gem_on_pedestal"), Advancements.description("chaos_gem_on_pedestal"), null, FrameType.GOAL, true, true, false).func_200275_a("place", (ICriterionInstance)Advancements.placedBlockWithItem(ItemPredicate.Builder.func_200309_a().func_200307_a(GemsTags.Items.CHAOS_GEMS).func_200310_b())).func_203904_a(consumer, Advancements.id("chaos_gem_on_pedestal"));
            Advancement enderCrystal = Advancements.simpleGetItem(consumer, CraftingItems.ENDER_CRYSTAL, root, "ender_crystal");
            Advancement enderCrystalBlock = Advancement.Builder.func_200278_a().func_203905_a(enderCrystal).func_203902_a((IItemProvider)MiscBlocks.ENDER_CRYSTAL, Advancements.title("ender_crystal_block"), Advancements.description("ender_crystal_block"), null, FrameType.TASK, true, true, false).func_200275_a("walk_on", (ICriterionInstance)GenericIntTrigger.Instance.instance((ResourceLocation)MiscBlocks.WALK_ON_ENDER_CRYSTAL, (int)1)).func_203904_a(consumer, Advancements.id("ender_crystal_block"));
            Advancement teleporter = Advancements.simpleGetItem(consumer, GemsTags.Items.TELEPORTERS, (IItemProvider)Gems.SAPPHIRE.getTeleporter(), enderCrystal, "teleporter");
            Advancement linkTeleporter = Advancement.Builder.func_200278_a().func_203905_a(teleporter).func_203902_a(GemsItems.TELEPORTER_LINKER, Advancements.title("link_teleporter"), Advancements.description("link_teleporter"), null, FrameType.TASK, true, true, false).func_200275_a("get_link", Advancements.getItem(new IItemProvider[]{GemsItems.TELEPORTER_LINKER})).func_200275_a("link_teleporters", (ICriterionInstance)Advancements.placedBlockWithItem(ItemPredicate.Builder.func_200309_a().func_200308_a(GemsItems.TELEPORTER_LINKER).func_200310_b())).func_203904_a(consumer, Advancements.id("link_teleporter"));
            Advancement soulGem = Advancements.simpleGetItem(consumer, GemsItems.SOUL_GEM, root, "soul_gem");
            Advancement soulUrn = Advancements.simpleGetItem(consumer, GemsBlocks.SOUL_URN, soulGem, "soul_urn");
            Advancement glowrose = Advancements.simpleGetItem(consumer, GemsTags.Items.GLOWROSES, (IItemProvider)Gems.RUBY.getGlowrose(), root, "glowrose");
            Advancement luminousFlowerPot = Advancement.Builder.func_200278_a().func_203905_a(glowrose).func_203902_a(GemsBlocks.LUMINOUS_FLOWER_POT, Advancements.title("luminous_flower_pot"), Advancements.description("luminous_flower_pot"), null, FrameType.GOAL, true, true, false).func_200275_a("get_pot", Advancements.getItem(new IItemProvider[]{GemsBlocks.LUMINOUS_FLOWER_POT})).func_200275_a("plant_flower", (ICriterionInstance)Advancements.placedBlockWithItem(ItemPredicate.Builder.func_200309_a().func_200307_a(GemsTags.Items.GLOWROSES).func_200310_b())).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("luminous_flower_pot"));
            Advancement growFluffyPuffs = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)CraftingItems.FLUFFY_PUFF, Advancements.title("grow_fluffy_puffs"), Advancements.description("grow_fluffy_puffs"), null, FrameType.TASK, true, true, false).func_200275_a("plant_seeds", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)GemsBlocks.FLUFFY_PUFF_PLANT.get()))).func_200275_a("harvest", Advancements.getItem(CraftingItems.FLUFFY_PUFF)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("grow_fluffy_puffs"));
            Advancement fluffyBlocks = Advancements.simpleGetItem(consumer, GemsTags.Items.FLUFFY_BLOCKS, GemsBlocks.WHITE_FLUFFY_BLOCK, growFluffyPuffs, "fluffy_block");
            Advancement hardenedRock = Advancements.simpleGetItem(consumer, GemsTags.Items.HARDENED_ROCKS, (IItemProvider)HardenedRock.STONE.asBlock(), root, "hardened_rock");
        }

        @Nonnull
        private static PlacedBlockTrigger.Instance placedBlockWithItem(ItemPredicate item) {
            return new PlacedBlockTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, null, StatePropertiesPredicate.field_227178_a_, LocationPredicate.field_193455_a, item);
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, IItemProvider item, Advancement parent, String key) {
            return Advancements.simpleGetItem(consumer, Advancements.getItem(item), new ItemStack(item), parent, key);
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, ITag<Item> item, IItemProvider icon, Advancement parent, String key) {
            return Advancements.simpleGetItem(consumer, Advancements.getItem(item), new ItemStack(icon), parent, key);
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, ICriterionInstance item, ItemStack icon, Advancement parent, String key) {
            return Advancement.Builder.func_200278_a().func_203905_a(parent).func_215092_a(icon, Advancements.title(key), Advancements.description(key), null, FrameType.TASK, true, true, false).func_200275_a("get_item", item).func_203904_a(consumer, Advancements.id(key));
        }

        private static String id(String path) {
            return SilentGems.getId(path).toString();
        }

        private static ICriterionInstance getItem(IItemProvider ... items) {
            return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])items);
        }

        private static ICriterionInstance getItem(ITag<Item> tag) {
            return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(tag).func_200310_b()});
        }

        private static ICriterionInstance getItem(ITag<Item> tag, int count) {
            return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.IntBound.func_211340_b((int)count), MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, NBTPredicate.field_193479_a)});
        }

        private static ICriterionInstance genericInt(ResourceLocation id, int value) {
            return GenericIntTrigger.Instance.instance((ResourceLocation)id, (int)value);
        }

        private static ITextComponent title(String key) {
            return new TranslationTextComponent("advancements.silentgems." + key + ".title");
        }

        private static ITextComponent description(String key) {
            return new TranslationTextComponent("advancements.silentgems." + key + ".description");
        }
    }
}

