/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.FluffyBlock;
import net.silentchaos512.gems.block.GemBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.block.pedestal.PedestalBlock;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GemsBlockTagsProvider
extends BlockTagsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public GemsBlockTagsProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "silentgems", existingFileHelper);
    }

    public String func_200397_b() {
        return "Silent's Gems - Block Tags";
    }

    protected void func_200432_c() {
        this.builder((ITag.INamedTag<Block>)BlockTags.field_226152_ab_, (IBlockProvider)GemsBlocks.FLUFFY_PUFF_PLANT);
        this.getBuilder((ITag.INamedTag<Block>)BlockTags.field_201151_l).func_240534_a_((Object[])new Block[]{CorruptedBlocks.STONE.asBlock()}).func_240534_a_((Object[])new Block[]{CorruptedBlocks.DIRT.asBlock()}).func_240531_a_(GemsTags.Blocks.GLOWROSES);
        this.getBuilder((ITag.INamedTag<Block>)BlockTags.field_200032_i).func_240534_a_((Object[])Registration.getBlocks(FlowerPotBlock.class).toArray(new Block[0]));
        this.getBuilder((ITag.INamedTag<Block>)BlockTags.field_219746_E).func_240531_a_(GemsTags.Blocks.GLOWROSES);
        this.getBuilder((ITag.INamedTag<Block>)BlockTags.field_232875_ap_).func_240534_a_((Object[])Registration.getBlocks(GemBlock.class).toArray(new Block[0])).func_240534_a_((Object[])new Block[]{MiscBlocks.SILVER.asBlock(), MiscBlocks.CHAOS_IRON.asBlock(), MiscBlocks.CHAOS_GOLD.asBlock(), MiscBlocks.CHAOS_SILVER.asBlock()});
        for (Gems gem2 : Gems.values()) {
            this.builder(gem2.getOreTag(), gem2::getOre);
            this.builder(gem2.getBlockTag(), gem2::getBlock);
            this.builder(gem2.getGlowroseTag(), gem2::getGlowrose);
        }
        this.gemBuilder(GemsTags.Blocks.GEM_BLOCKS, Gems::getBlockTag);
        this.builder(GemsTags.Blocks.ORES_SILVER, MiscOres.SILVER);
        this.builder(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS, MiscBlocks.CHAOS_CRYSTAL);
        this.builder(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_COAL, MiscBlocks.CHAOS_IRON);
        this.builder(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_IRON, MiscBlocks.CHAOS_IRON);
        this.builder(GemsTags.Blocks.STORAGE_BLOCKS_SILVER, MiscBlocks.SILVER);
        TagsProvider.Builder oresBuilder = this.getBuilder((ITag.INamedTag<Block>)Tags.Blocks.ORES).func_240534_a_((Object[])new Block[]{(Block)GemsBlocks.MULTI_ORE_CLASSIC.get()}).func_240534_a_((Object[])new Block[]{(Block)GemsBlocks.MULTI_ORE_DARK.get()}).func_240534_a_((Object[])new Block[]{(Block)GemsBlocks.MULTI_ORE_LIGHT.get()}).func_240534_a_((Object[])new Block[]{MiscOres.CHAOS.asBlock()}).func_240534_a_((Object[])new Block[]{MiscOres.ENDER.asBlock()}).func_240531_a_(GemsTags.Blocks.ORES_SILVER);
        Arrays.stream(Gems.values()).forEach(gem -> oresBuilder.func_240531_a_(gem.getOreTag()));
        TagsProvider.Builder storageBlocksBuilder = this.getBuilder((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS).func_240531_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS).func_240531_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_COAL).func_240531_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_IRON).func_240531_a_(GemsTags.Blocks.STORAGE_BLOCKS_SILVER);
        Arrays.stream(Gems.values()).forEach(gem -> storageBlocksBuilder.func_240531_a_(gem.getBlockTag()));
        TagsProvider.Builder<Block> glowrosesBuilder = this.getBuilder(GemsTags.Blocks.GLOWROSES);
        Arrays.stream(Gems.values()).forEach(gem -> glowrosesBuilder.func_240531_a_(gem.getGlowroseTag()));
        this.getBuilder(GemsTags.Blocks.FLUFFY_BLOCKS).func_240534_a_((Object[])Registration.getBlocks(FluffyBlock.class).toArray(new Block[0]));
        this.getBuilder(GemsTags.Blocks.HARDENED_ROCKS).func_240534_a_((Object[])Registration.getBlocks(HardenedRock.HardenedRockBlock.class).toArray(new Block[0]));
        this.getBuilder(GemsTags.Blocks.CORRUPTABLE_DIRT).func_240531_a_((ITag.INamedTag)Tags.Blocks.DIRT).func_240534_a_((Object[])new Block[]{Blocks.field_150349_c});
        this.getBuilder(GemsTags.Blocks.CORRUPTABLE_STONE).func_240531_a_((ITag.INamedTag)Tags.Blocks.STONE);
        this.getBuilder(GemsTags.Blocks.PEDESTALS).func_240534_a_((Object[])Registration.getBlocks(PedestalBlock.class).toArray(new Block[0]));
        this.getBuilder(GemsTags.Blocks.SUPERCHARGER_PILLAR_CAP).func_240531_a_(GemsTags.Blocks.GEM_BLOCKS).func_240531_a_(GemsTags.Blocks.STORAGE_BLOCKS_SILVER);
        this.getBuilder(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL1).func_240531_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_IRON);
        this.getBuilder(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL2).func_240534_a_((Object[])new Block[]{MiscBlocks.ENRICHED_CHAOS_CRYSTAL.asBlock()});
        this.getBuilder(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL3).func_240534_a_((Object[])new Block[]{MiscBlocks.ENDER_CRYSTAL.asBlock()});
    }

    private TagsProvider.Builder<Block> getBuilder(ITag.INamedTag<Block> tag) {
        return this.func_240522_a_(tag);
    }

    private void builder(ITag.INamedTag<Block> tag, IBlockProvider block) {
        this.builder(tag, Collections.singleton(block));
    }

    private void builder(ITag.INamedTag<Block> tag, Collection<? extends IBlockProvider> blocks) {
        this.getBuilder(tag).func_240534_a_((Object[])blocks.stream().map(IBlockProvider::asBlock).toArray(Block[]::new));
    }

    private void gemBuilder(ITag.INamedTag<Block> tag, Function<Gems, ITag.INamedTag<Block>> gemTagGetter) {
        TagsProvider.Builder<Block> builder = this.getBuilder(tag);
        Arrays.stream(Gems.values()).map(gemTagGetter).forEach(arg_0 -> builder.func_240531_a_(arg_0));
    }

    public void func_200398_a(DirectoryCache cache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        this.field_200434_b.forEach((p_240524_4_, p_240524_5_) -> {
            JsonObject jsonobject = p_240524_5_.func_232965_c_();
            Path path = this.func_200431_a((ResourceLocation)p_240524_4_);
            if (path == null) {
                return;
            }
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }
}

