/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.TagsProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.data.GemsBlockTagsProvider;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.ChaosGemItem;
import net.silentchaos512.gems.item.ChaosOrbItem;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.lib.Gems;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GemsItemTagsProvider
extends ItemTagsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public GemsItemTagsProvider(DataGenerator generatorIn, GemsBlockTagsProvider blocks, ExistingFileHelper existingFileHelper) {
        super(generatorIn, (BlockTagsProvider)blocks, "silentgems", existingFileHelper);
    }

    public String func_200397_b() {
        return "Silent's Gems - Item Tags";
    }

    protected void func_200432_c() {
        this.func_240521_a_(BlockTags.field_219746_E, ItemTags.field_226159_I_);
        this.getBuilder((ITag.INamedTag<Item>)ItemTags.field_232908_Z_).func_240534_a_((Object[])Arrays.stream(Gems.values()).map(Gems::getItem).toArray(Item[]::new)).func_240534_a_((Object[])new Item[]{CraftingItems.SILVER_INGOT.func_199767_j(), CraftingItems.CHAOS_IRON_INGOT.func_199767_j(), CraftingItems.CHAOS_GOLD_INGOT.func_199767_j(), CraftingItems.CHAOS_SILVER_INGOT.func_199767_j()});
        this.builder(GemsTags.Items.GEMS_CHAOS, CraftingItems.CHAOS_CRYSTAL);
        for (Gems gem : Gems.values()) {
            this.getBuilder(gem.getItemTag()).func_240534_a_((Object[])new Item[]{gem.getItem()});
            this.getBuilder(gem.getShardTag()).func_240534_a_((Object[])new Item[]{gem.getShard()});
            this.copyBlock(gem.getOreTag());
            this.copyBlock(gem.getBlockTag());
            this.copyBlock(gem.getGlowroseTag());
        }
        this.func_240521_a_(GemsTags.Blocks.ORES_SILVER, GemsTags.Items.ORES_SILVER);
        this.func_240521_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS, GemsTags.Items.STORAGE_BLOCKS_CHAOS);
        this.func_240521_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_COAL, GemsTags.Items.STORAGE_BLOCKS_CHAOS_COAL);
        this.func_240521_a_(GemsTags.Blocks.STORAGE_BLOCKS_CHAOS_IRON, GemsTags.Items.STORAGE_BLOCKS_CHAOS_IRON);
        this.func_240521_a_(GemsTags.Blocks.STORAGE_BLOCKS_SILVER, GemsTags.Items.STORAGE_BLOCKS_SILVER);
        this.gemBuilder((ITag.INamedTag<Item>)Tags.Items.GEMS, Gems::getItemTag);
        this.gemBuilder((ITag.INamedTag<Item>)Tags.Items.NUGGETS, Gems::getShardTag);
        this.func_240521_a_((ITag.INamedTag)Tags.Blocks.ORES, (ITag.INamedTag)Tags.Items.ORES);
        this.func_240521_a_((ITag.INamedTag)Tags.Blocks.STORAGE_BLOCKS, (ITag.INamedTag)Tags.Items.STORAGE_BLOCKS);
        this.func_240521_a_(GemsTags.Blocks.GLOWROSES, GemsTags.Items.GLOWROSES);
        this.builder(GemsTags.Items.INGOTS_SILVER, CraftingItems.SILVER_INGOT);
        this.builder(GemsTags.Items.NUGGETS_SILVER, CraftingItems.SILVER_NUGGET);
        this.builder((ITag.INamedTag<Item>)Tags.Items.INGOTS, CraftingItems.SILVER_INGOT);
        this.builder((ITag.INamedTag<Item>)Tags.Items.NUGGETS, CraftingItems.SILVER_NUGGET);
        this.builder((ITag.INamedTag<Item>)Tags.Items.CROPS, CraftingItems.FLUFFY_PUFF);
        this.getBuilder((ITag.INamedTag<Item>)Tags.Items.DUSTS).func_240531_a_(GemsTags.Items.CORRUPTED_DUSTS).func_240534_a_((Object[])new Item[]{CraftingItems.CHAOS_DUST.func_199767_j()});
        this.builder((ITag.INamedTag<Item>)ModTags.Items.PAPER, CraftingItems.FLUFFY_FABRIC);
        this.getBuilder((ITag.INamedTag<Item>)Tags.Items.SEEDS).func_240534_a_((Object[])new Item[]{GemsItems.FLUFFY_PUFF_SEEDS.func_199767_j()});
        this.getBuilder((ITag.INamedTag<Item>)Tags.Items.SLIMEBALLS).func_240534_a_((Object[])new Item[]{CraftingItems.CORRUPTED_SLIME_BALL.func_199767_j(), CraftingItems.ENDER_SLIME_BALL.func_199767_j()});
        this.builder(GemsTags.Items.CHAOS_GEMS, Registration.getItems(ChaosGemItem.class));
        this.builder(GemsTags.Items.CHAOS_ORBS, Registration.getItems(ChaosOrbItem.class));
        this.builder(GemsTags.Items.CHARGING_AGENT_TIER1, CraftingItems.CHARGING_AGENT);
        this.builder(GemsTags.Items.CHARGING_AGENT_TIER2, CraftingItems.SUPER_CHARGING_AGENT);
        this.builder(GemsTags.Items.CHARGING_AGENT_TIER3, CraftingItems.ULTRA_CHARGING_AGENT);
        this.getBuilder(GemsTags.Items.CHARGING_AGENTS).func_240531_a_(GemsTags.Items.CHARGING_AGENT_TIER1).func_240531_a_(GemsTags.Items.CHARGING_AGENT_TIER2).func_240531_a_(GemsTags.Items.CHARGING_AGENT_TIER3);
        this.getBuilder(GemsTags.Items.CORRUPTED_DUSTS).func_240534_a_((Object[])new Item[]{CorruptedBlocks.DIRT.getPile(), CorruptedBlocks.STONE.getPile()});
        this.func_240521_a_(GemsTags.Blocks.FLUFFY_BLOCKS, GemsTags.Items.FLUFFY_BLOCKS);
        this.func_240521_a_(GemsTags.Blocks.GEM_BLOCKS, GemsTags.Items.GEM_BLOCKS);
        this.gemBuilder(GemsTags.Items.GEMS, Gems::getItemTag);
        this.func_240521_a_(GemsTags.Blocks.HARDENED_ROCKS, GemsTags.Items.HARDENED_ROCKS);
        this.func_240521_a_(GemsTags.Blocks.PEDESTALS, GemsTags.Items.PEDESTALS);
        this.gemBuilderItem(GemsTags.Items.RETURN_HOME_CHARMS, Gems::getReturnHomeCharm);
        this.gemBuilder(GemsTags.Items.SHARDS, Gems::getShardTag);
        this.getBuilder(GemsTags.Items.STEW_FISH).func_240534_a_((Object[])new Item[]{Items.field_196086_aW, Items.field_196087_aX});
        this.getBuilder(GemsTags.Items.STEW_MEAT).func_240534_a_((Object[])new Item[]{Items.field_151082_bd, Items.field_151076_bf, Items.field_179561_bm, Items.field_151147_al, Items.field_179558_bo});
        this.func_240521_a_(GemsTags.Blocks.HARDENED_ROCKS, GemsTags.Items.HARDENED_ROCKS);
        this.func_240521_a_(GemsTags.Blocks.SUPERCHARGER_PILLAR_CAP, GemsTags.Items.SUPERCHARGER_PILLAR_CAP);
        this.func_240521_a_(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1);
        this.func_240521_a_(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL2, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL2);
        this.func_240521_a_(GemsTags.Blocks.SUPERCHARGER_PILLAR_LEVEL3, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL3);
        this.builder(GemsTags.Items.TELEPORTER_CATALYST, CraftingItems.ENDER_CRYSTAL);
        this.gemBuilderItem(GemsTags.Items.TELEPORTERS, Gems::getTeleporter);
        this.getBuilder(GemsTags.Items.WISP_ESSENCES).func_240534_a_((Object[])Arrays.stream(CraftingItems.values()).filter(item -> item.getName().endsWith("wisp_essence")).map(IItemProvider::func_199767_j).toArray(Item[]::new));
        this.gemSetBuilder(GemsTags.Items.GEMS_CLASSIC, Gems.Set.CLASSIC, Gems::getItemTag);
        this.gemSetBuilder(GemsTags.Items.GEMS_DARK, Gems.Set.DARK, Gems::getItemTag);
        this.gemSetBuilder(GemsTags.Items.GEMS_LIGHT, Gems.Set.LIGHT, Gems::getItemTag);
    }

    private TagsProvider.Builder<Item> getBuilder(ITag.INamedTag<Item> tag) {
        return this.func_240522_a_(tag);
    }

    private void builder(ITag.INamedTag<Item> tag, IItemProvider item) {
        this.builder(tag, Collections.singleton(item));
    }

    private void builder(ITag.INamedTag<Item> tag, Collection<? extends IItemProvider> items) {
        this.getBuilder(tag).func_240534_a_((Object[])items.stream().map(IItemProvider::func_199767_j).toArray(Item[]::new));
    }

    private void gemBuilder(ITag.INamedTag<Item> tag, Function<Gems, ITag.INamedTag<Item>> gemTagGetter) {
        TagsProvider.Builder<Item> builder = this.getBuilder(tag);
        for (Gems gems : Gems.values()) {
            ITag.INamedTag<Item> itemTag = gemTagGetter.apply(gems);
            builder.func_240531_a_(itemTag);
        }
    }

    private void gemBuilderItem(ITag.INamedTag<Item> tag, Function<Gems, IItemProvider> gemTagGetter) {
        TagsProvider.Builder<Item> builder = this.getBuilder(tag);
        for (Gems gems : Gems.values()) {
            Item item = gemTagGetter.apply(gems).func_199767_j();
            builder.func_240534_a_((Object[])new Item[]{item});
        }
    }

    private void gemSetBuilder(ITag.INamedTag<Item> tag, Gems.Set set, Function<Gems, ITag.INamedTag<Item>> gemTagGetter) {
        TagsProvider.Builder<Item> builder = this.getBuilder(tag);
        set.iterator().forEachRemaining(gem -> builder.func_240531_a_((ITag.INamedTag)gemTagGetter.apply((Gems)((Object)gem))));
    }

    private void copyBlock(ITag.INamedTag<Block> tag) {
        this.func_240521_a_(tag, ItemTags.func_199901_a((String)tag.func_230234_a_().toString()));
    }

    public void func_200398_a(DirectoryCache cache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        this.field_200434_b.forEach((p_240524_4_, p_240524_5_) -> {
            JsonObject jsonobject = p_240524_5_.func_232965_c_();
            Path path = this.func_200431_a((ResourceLocation)p_240524_4_);
            if (path == null) {
                return;
            }
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }
}

