/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsEntities;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsLootTables;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.lib.util.NameUtils;

public class GemsLootTableProvider
extends LootTableProvider {
    public GemsLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    public String func_200397_b() {
        return "Silent's Gems - Loot Tables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new GiftLootTables(), (Object)LootParameterSets.field_216264_e), (Object)Pair.of(() -> new EntityLootTables(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new BlockLootTables(), (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    private static final class BlockLootTables
    extends net.minecraft.data.loot.BlockLootTables {
        private BlockLootTables() {
        }

        protected void addTables() {
            for (Gems gems : Gems.values()) {
                this.func_218492_c(gems.getBlock());
                this.func_218492_c(gems.getBricks());
                this.func_218492_c((Block)gems.getGlass());
                this.func_218492_c((Block)gems.getGlowrose());
                this.func_218492_c(gems.getLamp(GemLampBlock.State.UNLIT));
                this.func_218492_c(gems.getLamp(GemLampBlock.State.INVERTED_LIT));
                this.func_218492_c(gems.getTeleporter());
                this.func_218492_c(gems.getRedstoneTeleporter());
                this.func_218507_a((Block)gems.getOre(), BlockLootTables.func_218476_a((Block)gems.getOre(), (Item)gems.getItem()));
                this.func_218547_a((Block)gems.getPottedGlowrose());
            }
            this.func_218492_c((Block)GemsBlocks.TELEPORTER_ANCHOR.get());
            this.func_218522_a((Block)GemsBlocks.MULTI_ORE_CLASSIC.get(), block -> BlockLootTables.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.CLASSIC_GEMS).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
            this.func_218522_a((Block)GemsBlocks.MULTI_ORE_DARK.get(), block -> BlockLootTables.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.DARK_GEMS).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
            this.func_218522_a((Block)GemsBlocks.MULTI_ORE_LIGHT.get(), block -> BlockLootTables.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.LIGHT_GEMS).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
            for (Enum enum_ : MiscBlocks.values()) {
                this.func_218492_c(((MiscBlocks)enum_).asBlock());
            }
            this.func_218522_a(MiscOres.CHAOS.asBlock(), block -> BlockLootTables.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.CHAOS_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)4.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))))));
            this.func_218522_a(MiscOres.ENDER.asBlock(), block -> BlockLootTables.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.ENDER_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)4.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))))));
            this.func_218492_c(MiscOres.SILVER.asBlock());
            for (Enum enum_ : CorruptedBlocks.values()) {
                this.func_218522_a(((CorruptedBlocks)enum_).asBlock(), arg_0 -> BlockLootTables.lambda$addTables$5((CorruptedBlocks)enum_, arg_0));
            }
            for (Enum enum_ : HardenedRock.values()) {
                this.func_218492_c(((HardenedRock)enum_).asBlock());
            }
            this.func_218492_c((Block)GemsBlocks.WHITE_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.ORANGE_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.MAGENTA_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.YELLOW_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.LIME_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.PINK_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.GRAY_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.CYAN_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.PURPLE_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.BLUE_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.BROWN_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.GREEN_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.RED_FLUFFY_BLOCK.get());
            this.func_218492_c((Block)GemsBlocks.BLACK_FLUFFY_BLOCK.get());
            this.func_218507_a((Block)GemsBlocks.SOUL_URN.get(), LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTables.func_218560_a(GemsBlocks.SOUL_URN, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(GemsBlocks.SOUL_URN).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Lock", "BlockEntityTag.Lock").func_216056_a("LootTable", "BlockEntityTag.LootTable").func_216056_a("LootTableSeed", "BlockEntityTag.LootTableSeed").func_216056_a("Lidded", "BlockEntityTag.Lidded").func_216056_a("Color", "BlockEntityTag.Color").func_216056_a("Gem", "BlockEntityTag.Gem").func_216056_a("Upgrades", "BlockEntityTag.Upgrades")).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)ShulkerBoxBlock.field_220169_b)))))));
            this.func_218492_c((Block)GemsBlocks.SUPERCHARGER.get());
            this.func_218492_c((Block)GemsBlocks.TOKEN_ENCHANTER.get());
            this.func_218492_c((Block)GemsBlocks.TRANSMUTATION_ALTAR.get());
            this.func_218492_c((Block)GemsBlocks.PURIFIER.get());
            this.func_218492_c((Block)GemsBlocks.STONE_PEDESTAL.get());
            this.func_218492_c((Block)GemsBlocks.GRANITE_PEDESTAL.get());
            this.func_218492_c((Block)GemsBlocks.DIORITE_PEDESTAL.get());
            this.func_218492_c((Block)GemsBlocks.ANDESITE_PEDESTAL.get());
            this.func_218492_c((Block)GemsBlocks.OBSIDIAN_PEDESTAL.get());
            this.func_218492_c((Block)GemsBlocks.LUMINOUS_FLOWER_POT.get());
            this.func_218522_a((Block)GemsBlocks.FLUFFY_PUFF_PLANT.get(), block -> {
                BlockStateProperty.Builder fluffyPuffMatureCondition = BlockStateProperty.func_215985_a((Block)((Block)GemsBlocks.FLUFFY_PUFF_PLANT.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)CropsBlock.field_176488_a, 7));
                return BlockLootTables.func_218541_a((Block)block, (Item)CraftingItems.FLUFFY_PUFF.func_199767_j(), (Item)((Item)GemsItems.FLUFFY_PUFF_SEEDS.get()), (ILootCondition.IBuilder)fluffyPuffMatureCondition).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.FLUFFY_PUFF).func_212840_b_((ILootCondition.IBuilder)fluffyPuffMatureCondition)).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3))));
            });
            this.func_218493_a((Block)GemsBlocks.WILD_FLUFFY_PUFF_PLANT.get(), (IItemProvider)GemsItems.FLUFFY_PUFF_SEEDS);
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        private static /* synthetic */ LootTable.Builder lambda$addTables$5(CorruptedBlocks block, Block b) {
            return BlockLootTables.func_218530_a((Block)b, (IItemProvider)block.getPile(), (IRandomRange)ConstantRange.func_215835_a((int)4));
        }
    }

    private static final class EntityLootTables
    extends net.minecraft.data.loot.EntityLootTables {
        private EntityLootTables() {
        }

        protected void addTables() {
            this.func_218582_a((EntityType)GemsEntities.CORRUPTED_SLIME.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.CORRUPTED_SLIME_BALL).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.15f, (float)0.05f)))));
            this.func_218582_a((EntityType)GemsEntities.ENDER_SLIME.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.ENDER_SLIME_BALL).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.075f, (float)0.025f)))));
            this.func_218582_a(WispTypes.CHAOS.getEntityType(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.CHAOS_WISP_ESSENCE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(0.0f, 2.0f))))));
            this.func_218582_a(WispTypes.FIRE.getEntityType(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.FIRE_WISP_ESSENCE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(0.0f, 2.0f))))));
            this.func_218582_a(WispTypes.ICE.getEntityType(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.ICE_WISP_ESSENCE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(0.0f, 2.0f))))));
            this.func_218582_a(WispTypes.LIGHTNING.getEntityType(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.LIGHTNING_WISP_ESSENCE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(0.0f, 2.0f))))));
            this.func_218582_a(WispTypes.WATER.getEntityType(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.WATER_WISP_ESSENCE).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(0.0f, 2.0f))))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(type -> "silentgems".equals(NameUtils.from((IForgeRegistryEntry)type).func_110624_b())).collect(Collectors.toList());
        }
    }

    private static final class GiftLootTables
    extends net.minecraft.data.loot.GiftLootTables {
        private GiftLootTables() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(GemsLootTables.CLASSIC_GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b(GemsTags.Items.GEMS_CLASSIC))));
            consumer.accept(GemsLootTables.DARK_GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b(GemsTags.Items.GEMS_DARK))));
            consumer.accept(GemsLootTables.LIGHT_GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b(GemsTags.Items.GEMS_LIGHT))));
            consumer.accept(GemsLootTables.GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.CLASSIC_GEMS).func_216086_a(15)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.DARK_GEMS).func_216086_a(5)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.LIGHT_GEMS).func_216086_a(1))));
            consumer.accept(GemsLootTables.BAGS_CLASSIC_GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)new RandomValueRange(2.0f, 3.0f)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.CLASSIC_GEMS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 4.0f))))));
            consumer.accept(GemsLootTables.BAGS_DARK_GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)new RandomValueRange(2.0f, 3.0f)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.DARK_GEMS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 4.0f))))));
            consumer.accept(GemsLootTables.BAGS_LIGHT_GEMS, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)new RandomValueRange(2.0f, 3.0f)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)GemsLootTables.LIGHT_GEMS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 4.0f))))));
        }
    }
}

