/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.client;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.FluffyPuffPlant;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsBlockStateProvider
extends BlockStateProvider {
    public GemsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "silentgems", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ResourceLocation flowerPotCross = this.mcLoc("block/flower_pot_cross");
        for (Gems gem : Gems.values()) {
            String name = gem.getName();
            this.simpleBlock((Block)gem.getOre(), "block/ore/gem/" + name);
            this.simpleBlock(gem.getBlock(), "block/gem/" + name + "_block");
            this.simpleBlock(gem.getBricks(), "block/bricks/" + name);
            this.simpleBlock((Block)gem.getGlass(), "block/glass/" + name);
            this.simpleBlock(gem.getLamp(GemLampBlock.State.UNLIT), "block/lamp/" + name);
            this.simpleBlock(gem.getLamp(GemLampBlock.State.LIT), "block/lamp/" + name + "_lit");
            this.simpleBlock(gem.getLamp(GemLampBlock.State.INVERTED_LIT), "block/lamp/" + name + "_lit");
            this.simpleBlock(gem.getLamp(GemLampBlock.State.INVERTED_UNLIT), "block/lamp/" + name);
            this.simpleBlock((Block)gem.getGlowrose(), (ModelFile)this.models().cross(name + "_glowrose", this.modLoc("block/glowrose/" + name)));
            this.simpleBlock((Block)gem.getPottedGlowrose(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(NameUtils.from((IForgeRegistryEntry)gem.getPottedGlowrose()).func_110623_a(), flowerPotCross)).texture("plant", this.modLoc("block/glowrose/" + name)));
            this.simpleBlock(gem.getTeleporter(), "block/teleporter/standard/" + name);
            this.simpleBlock(gem.getRedstoneTeleporter(), "block/teleporter/redstone/" + name);
        }
        this.simpleBlock((IBlockProvider)GemsBlocks.TELEPORTER_ANCHOR, "block/teleporter/anchor");
        this.simpleBlock((IBlockProvider)GemsBlocks.MULTI_ORE_CLASSIC, "block/ore/multi_classic");
        this.simpleBlock((IBlockProvider)GemsBlocks.MULTI_ORE_DARK, "block/ore/multi_dark");
        this.simpleBlock((IBlockProvider)GemsBlocks.MULTI_ORE_LIGHT, "block/ore/multi_light");
        Arrays.stream(MiscBlocks.values()).forEach(this::simpleBlock);
        Arrays.stream(MiscOres.values()).forEach(block -> this.simpleBlock((IBlockProvider)block, "block/ore/" + block.getName()));
        Arrays.stream(CorruptedBlocks.values()).forEach(this::simpleBlock);
        Arrays.stream(HardenedRock.values()).forEach(this::simpleBlock);
        this.simpleBlock((IBlockProvider)GemsBlocks.WHITE_FLUFFY_BLOCK, "block/fluffy/white");
        this.simpleBlock((IBlockProvider)GemsBlocks.ORANGE_FLUFFY_BLOCK, "block/fluffy/orange");
        this.simpleBlock((IBlockProvider)GemsBlocks.MAGENTA_FLUFFY_BLOCK, "block/fluffy/magenta");
        this.simpleBlock((IBlockProvider)GemsBlocks.LIGHT_BLUE_FLUFFY_BLOCK, "block/fluffy/light_blue");
        this.simpleBlock((IBlockProvider)GemsBlocks.YELLOW_FLUFFY_BLOCK, "block/fluffy/yellow");
        this.simpleBlock((IBlockProvider)GemsBlocks.LIME_FLUFFY_BLOCK, "block/fluffy/lime");
        this.simpleBlock((IBlockProvider)GemsBlocks.PINK_FLUFFY_BLOCK, "block/fluffy/pink");
        this.simpleBlock((IBlockProvider)GemsBlocks.GRAY_FLUFFY_BLOCK, "block/fluffy/gray");
        this.simpleBlock((IBlockProvider)GemsBlocks.LIGHT_GRAY_FLUFFY_BLOCK, "block/fluffy/light_gray");
        this.simpleBlock((IBlockProvider)GemsBlocks.CYAN_FLUFFY_BLOCK, "block/fluffy/cyan");
        this.simpleBlock((IBlockProvider)GemsBlocks.PURPLE_FLUFFY_BLOCK, "block/fluffy/purple");
        this.simpleBlock((IBlockProvider)GemsBlocks.BLUE_FLUFFY_BLOCK, "block/fluffy/blue");
        this.simpleBlock((IBlockProvider)GemsBlocks.BROWN_FLUFFY_BLOCK, "block/fluffy/brown");
        this.simpleBlock((IBlockProvider)GemsBlocks.GREEN_FLUFFY_BLOCK, "block/fluffy/green");
        this.simpleBlock((IBlockProvider)GemsBlocks.RED_FLUFFY_BLOCK, "block/fluffy/red");
        this.simpleBlock((IBlockProvider)GemsBlocks.BLACK_FLUFFY_BLOCK, "block/fluffy/black");
        this.threeQuartersBlock((IBlockProvider)GemsBlocks.SUPERCHARGER);
        this.threeQuartersBlock((IBlockProvider)GemsBlocks.TOKEN_ENCHANTER);
        this.threeQuartersBlock((IBlockProvider)GemsBlocks.TRANSMUTATION_ALTAR);
        this.threeQuartersBlock((IBlockProvider)GemsBlocks.PURIFIER);
        this.pedestal((Block)GemsBlocks.ANDESITE_PEDESTAL.get(), this.mcLoc("block/andesite"));
        this.pedestal((Block)GemsBlocks.DIORITE_PEDESTAL.get(), this.mcLoc("block/diorite"));
        this.pedestal((Block)GemsBlocks.GRANITE_PEDESTAL.get(), this.mcLoc("block/granite"));
        this.pedestal((Block)GemsBlocks.STONE_PEDESTAL.get(), this.mcLoc("block/stone"));
        this.pedestal((Block)GemsBlocks.OBSIDIAN_PEDESTAL.get(), this.mcLoc("block/obsidian"));
        this.getVariantBuilder((Block)GemsBlocks.FLUFFY_PUFF_PLANT.get()).forAllStates(state -> {
            int i = this.cropAgeToIndex((Integer)state.func_177229_b((Property)FluffyPuffPlant.field_176488_a));
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross("fluffy_puff_plant" + i, this.modLoc("block/fluffy_plant" + i))).build();
        });
        this.simpleBlock((Block)GemsBlocks.WILD_FLUFFY_PUFF_PLANT.get(), (ModelFile)this.models().cross(NameUtils.from((IForgeRegistryEntry)GemsBlocks.WILD_FLUFFY_PUFF_PLANT.get()).func_110623_a(), this.modLoc("block/fluffy_plant3")));
    }

    private int cropAgeToIndex(int age) {
        if (age > 6) {
            return 3;
        }
        if (age > 3) {
            return 2;
        }
        if (age > 1) {
            return 1;
        }
        return 0;
    }

    private void simpleBlock(IBlockProvider block) {
        this.simpleBlock(block.asBlock());
    }

    private void simpleBlock(IBlockProvider block, String texture) {
        this.simpleBlock(block.asBlock(), texture);
    }

    private void simpleBlock(Block block, String texture) {
        String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(name, this.modLoc(texture)));
    }

    private void threeQuartersBlock(IBlockProvider block) {
        String name = NameUtils.from((IForgeRegistryEntry)block.asBlock()).func_110623_a();
        this.threeQuartersBlock(block.asBlock(), "block/" + name + "_bottom", "block/" + name + "_side", "block/" + name + "_top");
    }

    private void threeQuartersBlock(Block block, String bottomTexture, String sideTexture, String topTexture) {
        String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/block"))).texture("bottom", bottomTexture)).texture("side", sideTexture)).texture("top", topTexture)).texture("particle", bottomTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 12.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.EAST).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.SOUTH).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.WEST).uvs(0.0f, 4.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#bottom").end().end());
    }

    private void pedestal(Block block, ResourceLocation stone) {
        String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/pedestal"))).texture("stone", stone));
    }
}

