/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.client;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.block.FluffyBlock;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.HardenedRock;
import net.silentchaos512.gems.block.MiscBlocks;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.block.pedestal.PedestalBlock;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.ChaosMeterItem;
import net.silentchaos512.gems.item.ChaosOrbItem;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.item.ModFoods;
import net.silentchaos512.gems.item.SoulUrnUpgrades;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsItemModelProvider
extends ItemModelProvider {
    public GemsItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "silentgems", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Silent's Gems - Item Models";
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(new ResourceLocation("item/generated"));
        Registration.getBlocks(FluffyBlock.class).forEach(this::blockBuilder);
        Registration.getBlocks(PedestalBlock.class).forEach(this::blockBuilder);
        Arrays.stream(HardenedRock.values()).forEach(this::blockBuilder);
        Arrays.stream(MiscBlocks.values()).forEach(this::blockBuilder);
        Arrays.stream(MiscOres.values()).forEach(this::blockBuilder);
        Arrays.stream(CorruptedBlocks.values()).forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        this.blockBuilder((IBlockProvider)GemsBlocks.MULTI_ORE_CLASSIC);
        this.blockBuilder((IBlockProvider)GemsBlocks.MULTI_ORE_DARK);
        this.blockBuilder((IBlockProvider)GemsBlocks.MULTI_ORE_LIGHT);
        this.blockBuilder((IBlockProvider)GemsBlocks.LUMINOUS_FLOWER_POT);
        this.blockBuilder((IBlockProvider)GemsBlocks.PURIFIER);
        this.blockBuilder((IBlockProvider)GemsBlocks.SUPERCHARGER);
        this.blockBuilder((IBlockProvider)GemsBlocks.TOKEN_ENCHANTER);
        this.blockBuilder((IBlockProvider)GemsBlocks.TRANSMUTATION_ALTAR);
        this.blockBuilder((IBlockProvider)GemsBlocks.TELEPORTER_ANCHOR);
        for (Gems gem : Gems.values()) {
            String name = gem.getName();
            this.blockBuilder((Block)gem.getOre());
            this.blockBuilder(gem.getBlock());
            this.blockBuilder(gem.getBricks());
            this.blockBuilder((Block)gem.getGlass());
            this.blockBuilder(gem.getLamp(GemLampBlock.State.UNLIT));
            this.blockBuilder(gem.getLamp(GemLampBlock.State.INVERTED_LIT));
            this.blockBuilder(gem.getTeleporter());
            this.blockBuilder(gem.getRedstoneTeleporter());
            this.builder((IItemProvider)gem.getGlowrose(), (ModelFile)itemGenerated, "block/glowrose/" + name);
            this.builder((IItemProvider)gem.getItem(), (ModelFile)itemGenerated, "item/gem/" + name);
            this.builder((IItemProvider)gem.getShard(), (ModelFile)itemGenerated, "item/shard/" + name);
            this.builder((IItemProvider)gem.getChaosGem(), (ModelFile)itemGenerated, "item/chaos_gem/" + name);
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)gem.getReturnHomeCharm()).func_110623_a())).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/return_home_gem"))).texture("layer1", this.modLoc("item/return_home_base"));
        }
        Arrays.stream(CraftingItems.values()).forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        Arrays.stream(ModFoods.values()).forEach(arg_0 -> this.lambda$registerModels$2((ModelFile)itemGenerated, arg_0));
        Arrays.stream(SoulUrnUpgrades.values()).forEach(arg_0 -> this.lambda$registerModels$3((ModelFile)itemGenerated, arg_0));
        Registration.getItems(SpawnEggItem.class).forEach(item -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)item).func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/template_spawn_egg")));
        });
        for (int i = 1; i < 8; ++i) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("chaos_meter_" + i)).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/chaos_meter"))).texture("layer1", this.modLoc("item/chaos_meter_" + i));
        }
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("chaos_meter")).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/chaos_meter"))).texture("layer1", this.modLoc("item/chaos_meter_1"))).override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_1"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 0.0f).end().override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_2"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 100.0f).end().override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_3"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 1000.0f).end().override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_4"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 10000.0f).end().override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_5"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 100000.0f).end().override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_6"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 1000000.0f).end().override().model((ModelFile)this.getExistingFile(this.modLoc("chaos_meter_7"))).predicate(ChaosMeterItem.CHAOS_LEVEL, 1.0E7f).end();
        for (EnchantmentTokenItem.Icon icon : EnchantmentTokenItem.Icon.values()) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("enchantment_token_" + icon.getName())).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/enchantment_token/base"))).texture("layer1", this.modLoc("item/enchantment_token/outline"))).texture("layer2", this.modLoc("item/enchantment_token/" + icon.getName()));
        }
        ItemModelBuilder enchantmentTokenBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("enchantment_token")).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/enchantment_token/any"));
        for (EnchantmentTokenItem.Icon icon : EnchantmentTokenItem.Icon.values()) {
            enchantmentTokenBuilder.override().model((ModelFile)this.getExistingFile(this.modLoc("item/enchantment_token_" + icon.getName()))).predicate(EnchantmentTokenItem.MODEL_INDEX, (float)icon.ordinal()).end();
        }
        this.builder((IItemProvider)GemsItems.CHAOS_POTATO, (ModelFile)itemGenerated);
        this.chaosOrb((ChaosOrbItem)GemsItems.FRAGILE_CHAOS_ORB.get(), "crack2", "crack4");
        this.chaosOrb((ChaosOrbItem)GemsItems.REFINED_CHAOS_ORB.get(), "crack1", "crack2", "crack3", "crack4");
        this.chaosOrb((ChaosOrbItem)GemsItems.PERFECT_CHAOS_ORB.get(), "crack1", "crack2", "crack3", "crack4");
        this.builder((IItemProvider)GemsItems.CORRUPTING_POWDER, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.PURIFYING_POWDER, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.FLUFFY_PUFF_SEEDS, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.GEM_BAG, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.GLOWROSE_BASKET, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.GLOWROSE_FERTILIZER, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.SUMMON_KITTY, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.SUMMON_PUPPY, (ModelFile)itemGenerated);
        this.builder((IItemProvider)GemsItems.TELEPORTER_LINKER, (ModelFile)itemGenerated);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("soul_gem")).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/soul_gem_back"))).texture("layer1", this.modLoc("item/soul_gem_front"));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("gear_soul")).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/gear_soul_middle"))).texture("layer1", this.modLoc("item/gear_soul_left"))).texture("layer2", this.modLoc("item/gear_soul_right"))).texture("layer3", this.modLoc("item/gear_soul_highlight"));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("chaos_rune")).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/chaos_rune_base"))).texture("layer1", this.modLoc("item/chaos_rune_overlay"));
    }

    private void chaosOrb(ChaosOrbItem item, String ... crackTextures) {
        String name = NameUtils.from((IForgeRegistryEntry)item).func_110623_a();
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        for (int i = 0; i < crackTextures.length; ++i) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name + "_crack" + (i + 1))).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/" + name))).texture("layer1", this.modLoc("item/chaos_orb_" + crackTextures[i]));
        }
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)itemGenerated)).texture("layer0", this.modLoc("item/" + name));
        for (int i = 0; i < crackTextures.length; ++i) {
            int stage = i + 1;
            builder.override().model((ModelFile)this.getExistingFile(this.modLoc("item/" + name + "_crack" + stage))).predicate(ChaosOrbItem.CRACK_STAGE, (float)stage).end();
        }
    }

    private void blockBuilder(IBlockProvider block) {
        this.blockBuilder(block.asBlock());
    }

    private void blockBuilder(Block block) {
        String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
        this.withExistingParent(name, this.modLoc("block/" + name));
    }

    private void builder(IItemProvider item, ModelFile parent) {
        String name = NameUtils.fromItem((IItemProvider)item).func_110623_a();
        this.builder(item, parent, "item/" + name);
    }

    private void builder(IItemProvider item, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((IItemProvider)item).func_110623_a())).parent(parent)).texture("layer0", this.modLoc(texture));
    }

    private /* synthetic */ void lambda$registerModels$3(ModelFile itemGenerated, SoulUrnUpgrades item) {
        this.builder(item, itemGenerated);
    }

    private /* synthetic */ void lambda$registerModels$2(ModelFile itemGenerated, ModFoods item) {
        this.builder(item, itemGenerated);
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, CraftingItems item) {
        this.builder(item, itemGenerated);
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, CorruptedBlocks block) {
        this.blockBuilder(block);
        this.builder((IItemProvider)block.getPile(), itemGenerated);
    }
}

