/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsEntities;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.ChaosMeterItem;
import net.silentchaos512.gems.item.ChaosOrbItem;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.item.GlowroseFertilizerItem;
import net.silentchaos512.gems.item.ModFoods;
import net.silentchaos512.gems.item.PatchBlockChangerItem;
import net.silentchaos512.gems.item.PetSummonerItem;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.item.SoulUrnUpgrades;
import net.silentchaos512.gems.item.TeleporterLinkerItem;
import net.silentchaos512.gems.item.container.GemBagItem;
import net.silentchaos512.gems.item.container.GlowroseBasketItem;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.lib.registry.ItemRegistryObject;

public final class GemsItems {
    public static final ItemRegistryObject<GemBagItem> GEM_BAG;
    public static final ItemRegistryObject<GlowroseBasketItem> GLOWROSE_BASKET;
    public static final ItemRegistryObject<SoulGemItem> SOUL_GEM;
    public static final ItemRegistryObject<GearSoulItem> GEAR_SOUL;
    public static final ItemRegistryObject<EnchantmentTokenItem> ENCHANTMENT_TOKEN;
    public static final ItemRegistryObject<ChaosRuneItem> CHAOS_RUNE;
    public static final ItemRegistryObject<TeleporterLinkerItem> TELEPORTER_LINKER;
    public static final ItemRegistryObject<ChaosMeterItem> CHAOS_METER;
    public static final ItemRegistryObject<PatchBlockChangerItem> CORRUPTING_POWDER;
    public static final ItemRegistryObject<PatchBlockChangerItem> PURIFYING_POWDER;
    public static final ItemRegistryObject<ChaosOrbItem> CHAOS_POTATO;
    public static final ItemRegistryObject<ChaosOrbItem> FRAGILE_CHAOS_ORB;
    public static final ItemRegistryObject<ChaosOrbItem> REFINED_CHAOS_ORB;
    public static final ItemRegistryObject<ChaosOrbItem> PERFECT_CHAOS_ORB;
    public static final ItemRegistryObject<BlockNamedItem> FLUFFY_PUFF_SEEDS;
    public static final ItemRegistryObject<GlowroseFertilizerItem> GLOWROSE_FERTILIZER;
    public static final ItemRegistryObject<PetSummonerItem> SUMMON_KITTY;
    public static final ItemRegistryObject<PetSummonerItem> SUMMON_PUPPY;
    public static final ItemRegistryObject<SpawnEggItem> CORRUPTED_SLIME_SPAWN_EGG;
    public static final ItemRegistryObject<SpawnEggItem> ENDER_SLIME_SPAWN_EGG;

    private GemsItems() {
    }

    public static void register() {
    }

    private static <T extends Item> ItemRegistryObject<T> register(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    static {
        Gems.registerItems();
        CraftingItems.registerItems();
        WispTypes.registerItems();
        CorruptedBlocks.registerItems();
        GEM_BAG = GemsItems.register("gem_bag", GemBagItem::new);
        GLOWROSE_BASKET = GemsItems.register("glowrose_basket", GlowroseBasketItem::new);
        SOUL_GEM = GemsItems.register("soul_gem", SoulGemItem::new);
        GEAR_SOUL = GemsItems.register("gear_soul", GearSoulItem::new);
        ENCHANTMENT_TOKEN = GemsItems.register("enchantment_token", EnchantmentTokenItem::new);
        CHAOS_RUNE = GemsItems.register("chaos_rune", ChaosRuneItem::new);
        TELEPORTER_LINKER = GemsItems.register("teleporter_linker", TeleporterLinkerItem::new);
        SoulUrnUpgrades.registerItems();
        CHAOS_METER = GemsItems.register("chaos_meter", ChaosMeterItem::new);
        CORRUPTING_POWDER = GemsItems.register("corrupting_powder", () -> new PatchBlockChangerItem(2, PatchBlockChangerItem::corruptBlock));
        PURIFYING_POWDER = GemsItems.register("purifying_powder", () -> new PatchBlockChangerItem(2, PatchBlockChangerItem::purifyBlock));
        CHAOS_POTATO = GemsItems.register("chaos_potato", () -> new ChaosOrbItem(0, 5000, 0.5f));
        FRAGILE_CHAOS_ORB = GemsItems.register("fragile_chaos_orb", () -> new ChaosOrbItem(2, 100000, 0.2f));
        REFINED_CHAOS_ORB = GemsItems.register("refined_chaos_orb", () -> new ChaosOrbItem(4, 1000000, 0.1f));
        PERFECT_CHAOS_ORB = GemsItems.register("perfect_chaos_orb", () -> new ChaosOrbItem(4, 10000000, 0.05f));
        ModFoods.registerItems();
        FLUFFY_PUFF_SEEDS = GemsItems.register("fluffy_puff_seeds", () -> new BlockNamedItem((Block)GemsBlocks.FLUFFY_PUFF_PLANT.get(), new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS)));
        GLOWROSE_FERTILIZER = GemsItems.register("glowrose_fertilizer", GlowroseFertilizerItem::new);
        SUMMON_KITTY = GemsItems.register("summon_kitty", () -> new PetSummonerItem(PetSummonerItem::getCat));
        SUMMON_PUPPY = GemsItems.register("summon_puppy", () -> new PetSummonerItem(PetSummonerItem::getDog));
        CORRUPTED_SLIME_SPAWN_EGG = GemsItems.register("corrupted_slime_spawn_egg", () -> new SpawnEggItem((EntityType)GemsEntities.CORRUPTED_SLIME.get(), 0x8B008B, 10040012, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        ENDER_SLIME_SPAWN_EGG = GemsItems.register("ender_slime_spawn_egg", () -> new SpawnEggItem((EntityType)GemsEntities.ENDER_SLIME.get(), 13107, 0xAA00AA, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    }
}

