/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.function.Supplier;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.RegistryObject;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.crafting.ingredient.SoulElementIngredient;
import net.silentchaos512.gems.crafting.ingredient.SoulGemIngredient;
import net.silentchaos512.gems.crafting.recipe.AltarTransmutationRecipe;
import net.silentchaos512.gems.crafting.recipe.ApplyChaosRuneRecipe;
import net.silentchaos512.gems.crafting.recipe.ApplyEnchantmentTokenRecipe;
import net.silentchaos512.gems.crafting.recipe.GearSoulRecipe;
import net.silentchaos512.gems.crafting.recipe.ModifySoulUrnRecipe;
import net.silentchaos512.gems.crafting.recipe.SoulUrnRecipe;
import net.silentchaos512.gems.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;

public final class GemsRecipeInit {
    public static final RegistryObject<AltarTransmutationRecipe.Serializer> ALTAR_TRANSMUTATION = GemsRecipeInit.registerSerializer("altar_transmutation", AltarTransmutationRecipe.Serializer::new);
    public static final RegistryObject<SpecialRecipeSerializer<?>> APPLY_CHAOS_RUNE = GemsRecipeInit.registerSerializer("apply_chaos_rune", () -> new SpecialRecipeSerializer(ApplyChaosRuneRecipe::new));
    public static final RegistryObject<SpecialRecipeSerializer<?>> APPLY_ENCHANTMENT_TOKEN = GemsRecipeInit.registerSerializer("apply_enchantment_token", () -> new SpecialRecipeSerializer(ApplyEnchantmentTokenRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> GEAR_SOUL_RECIPE = GemsRecipeInit.registerSerializer("gear_soul", () -> ExtendedShapedRecipe.Serializer.basic(GearSoulRecipe::new));
    public static final RegistryObject<SpecialRecipeSerializer<?>> MODIFY_SOUL_URN = GemsRecipeInit.registerSerializer("modify_soul_urn", () -> new SpecialRecipeSerializer(ModifySoulUrnRecipe::new));
    public static final RegistryObject<SoulUrnRecipe.Serializer> SOUL_URN = GemsRecipeInit.registerSerializer("soul_urn", SoulUrnRecipe.Serializer::new);
    public static final RegistryObject<TokenEnchanterRecipe.Serializer> TOKEN_ENCHANTING = GemsRecipeInit.registerSerializer("token_enchanting", TokenEnchanterRecipe.Serializer::new);

    private GemsRecipeInit() {
    }

    public static void register() {
        SoulElementIngredient.Serializer.register();
        SoulGemIngredient.Serializer.register();
        GemsRecipeInit.registerRecipeType("altar_transmutation", AltarTransmutationRecipe.RECIPE_TYPE);
        GemsRecipeInit.registerRecipeType("token_enchanting", TokenEnchanterRecipe.RECIPE_TYPE);
    }

    private static <T extends IRecipeSerializer<? extends IRecipe<?>>> RegistryObject<T> registerSerializer(String name, Supplier<T> serializer) {
        return Registration.RECIPE_SERIALIZERS.register(name, serializer);
    }

    private static void registerRecipeType(String name, IRecipeType<?> recipeType) {
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)SilentGems.getId(name), recipeType);
    }
}

