/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.init;

import java.util.Locale;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.RegistryObject;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.Registration;

public enum GemsSounds {
    SOUL_URN_LID(0.6f, 0.0f, 1.1f, 0.05f),
    SOUL_URN_OPEN(0.6f, 0.0f, 1.1f, 0.05f);

    RegistryObject<SoundEvent> sound;
    final float volume;
    final float volumeVariation;
    final float pitch;
    final float pitchVariation;

    private GemsSounds(float volume, float volumeVariation, float pitch, float pitchVariation) {
        this.volume = volume;
        this.volumeVariation = volumeVariation;
        this.pitch = pitch;
        this.pitchVariation = pitchVariation;
    }

    static void register() {
        for (GemsSounds sound : GemsSounds.values()) {
            sound.sound = Registration.SOUND_EVENTS.register(sound.getName(), () -> new SoundEvent(SilentGems.getId(sound.getName())));
        }
    }

    public SoundEvent get() {
        return (SoundEvent)this.sound.get();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public void play(IWorld world, BlockPos pos) {
        float volume = this.volume + this.volumeVariation * (float)SilentGems.random.nextGaussian();
        float pitch = this.pitch + this.pitchVariation * (float)SilentGems.random.nextGaussian();
        this.play(world, pos, volume, pitch);
    }

    public void play(IWorld world, BlockPos pos, float volume, float pitch) {
        world.func_184133_a(null, pos, this.get(), SoundCategory.PLAYERS, volume, pitch);
    }
}

