/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.lib.registry.ItemRegistryObject;

public enum CraftingItems implements IItemProvider
{
    CHAOS_CRYSTAL,
    ENRICHED_CHAOS_CRYSTAL,
    CHAOS_CRYSTAL_SHARD,
    CHAOS_DUST,
    ENDER_CRYSTAL,
    ENDER_CRYSTAL_SHARD,
    ENDER_FROST,
    NETHER_STAR_SHARD,
    SILVER_INGOT,
    SILVER_NUGGET,
    CHAOS_IRON_DUST,
    CHAOS_GOLD_DUST,
    CHAOS_SILVER_DUST,
    CHAOS_IRON_INGOT,
    CHAOS_GOLD_INGOT,
    CHAOS_SILVER_INGOT,
    CHARGING_AGENT,
    SUPER_CHARGING_AGENT,
    ULTRA_CHARGING_AGENT,
    CHAOS_COAL,
    ENDER_SLIME_BALL,
    CORRUPTED_SLIME_BALL,
    SLIME_CRYSTAL,
    MAGMA_CREAM_CRYSTAL,
    ENDER_SLIME_CRYSTAL,
    CHAOS_WISP_ESSENCE,
    FIRE_WISP_ESSENCE,
    WATER_WISP_ESSENCE,
    ICE_WISP_ESSENCE,
    LIGHTNING_WISP_ESSENCE,
    FLUFFY_PUFF,
    GILDED_STRING,
    BLANK_TOKEN,
    RUNE_SLATE,
    SOUL_SHELL,
    MYSTERY_GOO,
    FLUFFY_FABRIC,
    URN_UPGRADE_BASE,
    LOLINOMICON(false);

    private ItemRegistryObject<ItemCrafting> item;
    private final boolean shownInGroup;

    private CraftingItems() {
        this(true);
    }

    private CraftingItems(boolean shownInGroup) {
        this.shownInGroup = shownInGroup;
    }

    public static void registerItems() {
        for (CraftingItems item : CraftingItems.values()) {
            item.item = new ItemRegistryObject(Registration.ITEMS.register(item.getName(), () -> new ItemCrafting(item)));
        }
    }

    public Item func_199767_j() {
        return (Item)this.item.get();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ItemStack getStack() {
        return this.getStack(1);
    }

    public ItemStack getStack(int count) {
        return new ItemStack((IItemProvider)this, count);
    }

    static final class ItemCrafting
    extends Item {
        CraftingItems type;

        private ItemCrafting(CraftingItems type) {
            super(new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS));
            this.type = type;
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            String descKey = this.func_77658_a() + ".desc";
            if (I18n.func_188566_a((String)descKey)) {
                tooltip.add((ITextComponent)new TranslationTextComponent(descKey).func_240699_a_(TextFormatting.ITALIC));
            }
        }

        public int getBurnTime(ItemStack itemStack) {
            if (itemStack.func_77973_b() == CHAOS_COAL.func_199767_j()) {
                return (Integer)GemsConfig.Common.chaosCoalBurnTime.get();
            }
            return 0;
        }

        public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
            if (!this.type.shownInGroup || !this.func_194125_a(group)) {
                return;
            }
            super.func_150895_a(group, items);
        }
    }
}

