/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.lib.util.WorldUtils;

public class PatchBlockChangerItem
extends Item {
    private final int range;
    private final Function<Block, Block> replaceFunction;

    public PatchBlockChangerItem(int range, Function<Block, Block> replaceFunction) {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY).func_208103_a(Rarity.RARE));
        this.range = range;
        this.replaceFunction = replaceFunction;
    }

    public static Block corruptBlock(Block block) {
        for (CorruptedBlocks corruptedBlocks : CorruptedBlocks.values()) {
            if (!corruptedBlocks.canReplace(block)) continue;
            return corruptedBlocks.asBlock();
        }
        return block;
    }

    public static Block purifyBlock(Block block) {
        for (CorruptedBlocks corruptedBlocks : CorruptedBlocks.values()) {
            if (corruptedBlocks.asBlock() != block) continue;
            return corruptedBlocks.getPurifyBlock();
        }
        return block;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.applyToPatch(context.func_195991_k(), context.func_195995_a())) {
            context.func_195996_i().func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean applyToPatch(World world, BlockPos pos) {
        Map map = WorldUtils.getBlocksInSphere((World)world, (BlockPos)pos, (int)this.range, (w, p) -> Optional.of(w.func_180495_p(p).func_177230_c()));
        boolean changesMade = false;
        for (Map.Entry entry : map.entrySet()) {
            BlockPos pos1 = (BlockPos)entry.getKey();
            Block block = (Block)entry.getValue();
            Block newBlock = this.replaceFunction.apply(block);
            if (newBlock == block) continue;
            world.func_180501_a(pos1, newBlock.func_176223_P(), 3);
            changesMade = true;
        }
        return changesMade;
    }
}

