/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.init.GemsItemGroups;

public class PetSummonerItem
extends Item {
    private final Function<World, ? extends TameableEntity> petFactory;

    public PetSummonerItem(Function<World, ? extends TameableEntity> petFactory) {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY));
        this.petFactory = petFactory;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ResourceLocation registryName = Objects.requireNonNull(this.getRegistryName());
        String key = String.format("item.%s.%s.desc", registryName.func_110624_b(), registryName.func_110623_a());
        tooltip.add((ITextComponent)new TranslationTextComponent(key));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        if (world.field_72995_K || player == null) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return ActionResultType.PASS;
        }
        pos = pos.func_177972_a(facing);
        TameableEntity pet = this.petFactory.apply(world);
        pet.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        pet.field_70759_as = pet.field_70177_z;
        pet.field_70761_aq = pet.field_70177_z;
        world.func_217376_c((Entity)pet);
        pet.func_70642_aH();
        if (stack.func_82837_s()) {
            pet.func_200203_b(stack.func_200301_q());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        pet.func_70903_f(true);
        pet.func_184754_b(player.func_110124_au());
        world.func_72960_a((Entity)pet, (byte)7);
        pet.func_70606_j(pet.func_110138_aP());
        return ActionResultType.SUCCESS;
    }

    public static CatEntity getCat(World world) {
        CatEntity cat = new CatEntity(EntityType.field_220360_g, world);
        cat.func_213422_r(world.field_73012_v.nextInt(11));
        return cat;
    }

    public static WolfEntity getDog(World world) {
        return new WolfEntity(EntityType.field_200724_aC, world);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

