/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.lib.soul.SoulElement;

public class SoulGemItem
extends Item {
    private static final String NBT_KEY = "SGems_SoulGem";

    public SoulGemItem() {
        super(new Item.Properties().func_200916_a(GemsItemGroups.MATERIALS));
    }

    public static ItemStack getStack(Soul soul) {
        return SoulGemItem.getStack(soul, 1);
    }

    public static ItemStack getStack(Soul soul, int count) {
        ItemStack result = new ItemStack(GemsItems.SOUL_GEM, count);
        SoulGemItem.setSoul(result, soul);
        return result;
    }

    public static ItemStack getStack(ResourceLocation soulId) {
        ItemStack result = new ItemStack(GemsItems.SOUL_GEM);
        result.func_196082_o().func_74778_a(NBT_KEY, soulId.toString());
        return result;
    }

    public static void setSoul(ItemStack stack, Soul soul) {
        if (!(stack.func_77973_b() instanceof SoulGemItem)) {
            throw new IllegalArgumentException("Tried to set soul on item that is not a soul gem: " + stack);
        }
        stack.func_196082_o().func_74778_a(NBT_KEY, soul.getId().toString());
    }

    @Nullable
    public static Soul getSoul(ItemStack stack) {
        return Soul.from(SoulGemItem.getSoulId(stack));
    }

    private static String getSoulId(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_KEY);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        Soul soul = SoulGemItem.getSoul(stack);
        if (soul == null) {
            return 0xFFFFFF;
        }
        if (tintIndex == 0) {
            return soul.getPrimaryColor();
        }
        if (tintIndex == 1) {
            return soul.getSecondaryColor();
        }
        return 0xFFFFFF;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Soul soul = SoulGemItem.getSoul(stack);
        if (soul != null) {
            ITextComponent entityName = soul.getEntityName();
            return new TranslationTextComponent(this.func_77658_a() + ".nameProper", new Object[]{entityName});
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Soul soul = SoulGemItem.getSoul(stack);
        if (soul != null) {
            tooltip.add(soul.getPrimaryElement().getDisplayName());
            SoulElement element2 = soul.getSecondaryElement();
            if (element2 != SoulElement.NONE) {
                tooltip.add(element2.getDisplayName());
            }
            if (flagIn.func_194127_a()) {
                tooltip.add((ITextComponent)new StringTextComponent("Soul ID: " + soul.getId()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            if (GemsConfig.Common.debugExtraTooltipInfo.get().booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("DEBUG:"));
                tooltip.add((ITextComponent)new StringTextComponent(String.format("- Base drop rate: %.4f", Float.valueOf(soul.getBaseDropRate()))));
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        for (Soul soul : Soul.getValues()) {
            items.add((Object)SoulGemItem.getStack(soul));
        }
    }
}

