/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.lib.util.DimPos;

public final class TeleporterLinkerItem
extends Item {
    private static final String NBT_LINKED = "Linked";

    public TeleporterLinkerItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(GemsItemGroups.UTILITY));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (!TeleporterLinkerItem.isLinked(stack)) {
            return;
        }
        DimPos pos = TeleporterLinkerItem.getLinkedPosition(stack);
        if (!DimPos.ZERO.equals((Object)pos)) {
            list.add((ITextComponent)new StringTextComponent(pos.toString()));
        }
    }

    public static boolean isLinked(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(NBT_LINKED);
    }

    public static void setLinked(ItemStack stack, boolean value) {
        stack.func_196082_o().func_74757_a(NBT_LINKED, value);
    }

    public static DimPos getLinkedPosition(ItemStack stack) {
        return DimPos.read((CompoundNBT)stack.func_196082_o());
    }

    public static void setLinkedPosition(ItemStack stack, DimPos pos) {
        pos.write(stack.func_196082_o());
    }

    public boolean func_77636_d(ItemStack stack) {
        return TeleporterLinkerItem.isLinked(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGameOverlay(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            heldItem = player.func_184586_b(Hand.OFF_HAND);
        }
        if (heldItem.func_77973_b() == GemsItems.TELEPORTER_LINKER.get()) {
            FontRenderer fontRender = mc.field_71466_p;
            int width = mc.func_228018_at_().func_198107_o();
            int height = mc.func_228018_at_().func_198087_p();
            if (TeleporterLinkerItem.isLinked(heldItem)) {
                DimPos pos = TeleporterLinkerItem.getLinkedPosition(heldItem);
                double x = (double)pos.getX() - player.func_226277_ct_();
                double z = (double)pos.getZ() - player.func_226281_cx_();
                int distance = (int)Math.sqrt(x * x + z * z);
                String str = I18n.func_135052_a((String)"item.silentgems.teleporter_linker.distance", (Object[])new Object[]{distance});
                int textX = width / 2 - fontRender.func_78256_a(str) / 2;
                int textY = height * 3 / 5;
                int color = 0xFFFF00;
                if (pos.getDimension() != player.field_70170_p.func_234923_W_()) {
                    color = 0xFF6600;
                    str = I18n.func_135052_a((String)"item.silentgems.teleporter_linker.differentDimension", (Object[])new Object[0]);
                } else if (distance < (Integer)GemsConfig.Common.teleporterFreeRange.get()) {
                    color = 43775;
                }
                fontRender.func_238405_a_(event.getMatrixStack(), str, (float)textX, (float)textY, color);
            }
        }
    }
}

