/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.chaosbuff;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuffSerializer;
import net.silentchaos512.gems.lib.chaosbuff.PotionChaosBuff;
import net.silentchaos512.gems.lib.chaosbuff.SimpleChaosBuff;

public final class ChaosBuffSerializers {
    private static final Map<ResourceLocation, IChaosBuffSerializer<?>> REGISTRY = new HashMap();

    private ChaosBuffSerializers() {
    }

    public static <S extends IChaosBuffSerializer<T>, T extends IChaosBuff> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate chaos buff serializer " + serializer.getName());
        }
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IChaosBuff deserialize(ResourceLocation id, JsonObject json) {
        ResourceLocation type;
        IChaosBuffSerializer<?> serializer;
        String typeStr = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        if (!typeStr.contains(":")) {
            typeStr = "silentgems:" + typeStr;
        }
        if ((serializer = REGISTRY.get(type = new ResourceLocation(typeStr))) == null) {
            throw new JsonParseException("Invalid or unsupported chaos buff type " + type);
        }
        return serializer.read(id, json);
    }

    public static IChaosBuff read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        IChaosBuffSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown chaos buff serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IChaosBuff> void write(T buff, PacketBuffer buffer) {
        buffer.func_192572_a(buff.getId());
        buffer.func_192572_a(buff.getSerializer().getName());
        IChaosBuffSerializer<?> serializer = buff.getSerializer();
        serializer.write(buffer, buff);
    }

    static {
        ChaosBuffSerializers.register(SimpleChaosBuff.SERIALIZER);
        ChaosBuffSerializers.register(PotionChaosBuff.SERIALIZER);
    }
}

