/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.chaosbuff;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.silentchaos512.gems.init.GemsEffects;

public enum CostConditions {
    NO_CONDITION(p -> true),
    BURNING(Entity::func_70027_ad),
    FREEZING(p -> p.func_70660_b((Effect)GemsEffects.FREEZING.get()) != null),
    SHOCKING(p -> p.func_70660_b((Effect)GemsEffects.SHOCKING.get()) != null),
    FLYING(p -> p.field_71075_bZ.field_75100_b),
    HURT(p -> p.func_110143_aJ() < p.func_110138_aP() - 0.5f),
    IN_AIR(p -> !p.func_233570_aj_()),
    MOVING(CostConditions::hasMoved),
    UNDERWATER(Entity::func_70090_H);

    private final Predicate<PlayerEntity> condition;

    private CostConditions(Predicate<PlayerEntity> condition) {
        this.condition = condition;
    }

    public boolean appliesTo(PlayerEntity player) {
        return this.condition.test(player);
    }

    @Nullable
    public static CostConditions from(String str) {
        for (CostConditions c : CostConditions.values()) {
            if (!c.name().equalsIgnoreCase(str)) continue;
            return c;
        }
        return null;
    }

    private static boolean hasMoved(PlayerEntity player) {
        return true;
    }
}

