/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.chaosbuff;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuffSerializer;
import net.silentchaos512.gems.lib.chaosbuff.SimpleChaosBuff;

public class PotionChaosBuff
extends SimpleChaosBuff {
    private static final ResourceLocation SERIALIZER_ID = SilentGems.getId("potion");
    static final IChaosBuffSerializer<PotionChaosBuff> SERIALIZER = new SimpleChaosBuff.Serializer<PotionChaosBuff>(SERIALIZER_ID, PotionChaosBuff::new, (buff, json) -> {
        String str = JSONUtils.func_151200_h((JsonObject)json, (String)"effect");
        buff.effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(str));
        buff.effectDuration = JSONUtils.func_151208_a((JsonObject)json, (String)"effectDuration", (int)50);
    }, (buff, buffer) -> {
        buff.effect = (Effect)ForgeRegistries.POTIONS.getValue(buffer.func_192575_l());
        buff.effectDuration = buffer.func_150792_a();
    }, (buff, buffer) -> {
        buffer.func_192572_a(Objects.requireNonNull(buff.effect.getRegistryName()));
        buffer.func_150787_b(buff.effectDuration);
    });
    private Effect effect;
    private int effectDuration;

    public PotionChaosBuff(ResourceLocation id) {
        super(id);
    }

    public Effect getEffect() {
        return this.effect;
    }

    @Override
    public void applyTo(PlayerEntity player, int level) {
        if (this.effect == Effects.field_76439_r || player.func_70660_b(this.effect) == null) {
            player.func_195064_c(new EffectInstance(this.effect, this.effectDuration, level - 1, true, false));
        }
    }

    @Override
    public void removeFrom(PlayerEntity player) {
        player.func_195063_d(this.effect);
    }

    @Override
    public int getRuneColor() {
        if (this.effect != null) {
            return this.effect.func_76401_j();
        }
        return super.getRuneColor();
    }

    @Override
    public IChaosBuffSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

