/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.lib.soul.SoulElement;
import net.silentchaos512.gems.lib.soul.SoulTraits;

public class GearSoul {
    public static final float XP_FACTOR_KILLS = 0.35f;
    public static final float XP_FACTOR_TILLING = 4.0f;
    public static final float XP_FACTOR_BLOCK_MINED = 1.0f;
    public static final float XP_FACTOR_DAMAGE_TAKEN = 50.0f;
    public static final int XP_MAX_PER_BLOCK = 20;
    public static final float XP_MIN_BLOCK_HARDNESS = 0.5f;
    private static final int BASE_XP = 30;
    private static final float XP_CURVE_FACTOR = 3.0f;
    private String name = "";
    private final ItemStack item;

    public GearSoul(ItemStack stack) {
        this.item = stack;
    }

    private GearSoul(ItemStack stack, SoulElement primary, SoulElement secondary) {
        this.item = stack;
        this.getTag().func_74778_a("element1", primary.name());
        this.getTag().func_74778_a("element2", secondary.name());
    }

    private CompoundNBT getTag() {
        return !this.item.func_190926_b() ? this.item.func_190925_c("SG_GearSoul") : new CompoundNBT();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getXp() {
        return this.getTag().func_74762_e("xp");
    }

    public void setXp(int xp) {
        this.getTag().func_74768_a("xp", xp);
    }

    public int getLevel() {
        short level = this.getTag().func_74765_d("level");
        return level > 0 ? level : (short)1;
    }

    public void setLevel(int level) {
        this.getTag().func_74777_a("level", (short)level);
    }

    public SoulElement getPrimaryElement() {
        return SoulElement.fromString(this.getTag().func_74779_i("element1"));
    }

    public SoulElement getSecondaryElement() {
        return SoulElement.fromString(this.getTag().func_74779_i("element2"));
    }

    public Map<SoulTraits, Integer> getSkills() {
        LinkedHashMap<SoulTraits, Integer> ret = new LinkedHashMap<SoulTraits, Integer>();
        ListNBT listNbt = this.getTag().func_150295_c("skills", 10);
        for (int i = 0; i < listNbt.size(); ++i) {
            CompoundNBT nbt = listNbt.func_150305_b(i);
            SoulTraits trait = SoulTraits.get(nbt.func_74779_i("id"));
            if (trait == null) continue;
            ret.put(trait, Integer.valueOf(nbt.func_74765_d("level")));
        }
        return ret;
    }

    public ITextComponent getName() {
        if (this.name.isEmpty() && !this.item.func_190926_b()) {
            return this.item.func_200301_q();
        }
        return new StringTextComponent(this.name);
    }

    public void setName(String value) {
        this.name = value;
    }

    public void addXp(int amount, @Nullable PlayerEntity player) {
        if (!((Boolean)GemsConfig.Common.gearSoulsGetXpFromFakePlayers.get()).booleanValue() && player instanceof FakePlayer) {
            return;
        }
        this.setXp(this.getXp() + amount);
        while (this.getXp() >= this.getXpToNextLevel()) {
            this.levelUp(player);
        }
    }

    public int getXpToNextLevel() {
        return GearSoul.getXpForLevel(this.getLevel() + 1);
    }

    public static int getXpForLevel(int target) {
        return 30 * (int)Math.pow(target, 3.0);
    }

    @Nullable
    private SoulTraits levelUp(@Nullable PlayerEntity player) {
        SoulTraits toLearn;
        if (player != null && player.field_70170_p.field_72995_K) {
            return null;
        }
        this.setLevel(this.getLevel() + 1);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.levelUp", new Object[]{this.getName(), this.getLevel()}), Util.field_240973_b_);
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if ((toLearn = SoulTraits.selectTraitToLearn(this, this.item)) != null) {
            this.addOrLevelSkill(toLearn, player);
        }
        GearData.recalculateStats((ItemStack)this.item, (PlayerEntity)player);
        return toLearn;
    }

    public int getXpForBlockHarvest(IBlockReader world, BlockPos pos, BlockState state) {
        float hardness = state.func_185887_b(world, pos);
        if (hardness < 0.5f) {
            return 0;
        }
        int oreBonus = 0;
        Block block = state.func_177230_c();
        if (BlockTags.field_200031_h.func_230235_a_((Object)block) || Tags.Blocks.ORES.func_230235_a_((Object)block)) {
            oreBonus = this.getLevel() / 2;
        }
        if (state.func_185904_a() == Material.field_151575_d) {
            hardness /= 2.0f;
        }
        int clamp = MathHelper.func_76125_a((int)Math.round(1.0f * hardness), (int)1, (int)20);
        return oreBonus + clamp;
    }

    public void onBreakBlock(PlayerEntity player, IBlockReader world, BlockPos pos, BlockState blockState) {
        int xp = this.getXpForBlockHarvest(world, pos, blockState);
        this.addXp(xp, player);
    }

    public void onAttackedWith(PlayerEntity player, LivingEntity target, float damageAmount) {
        int xp = Math.round(0.35f * damageAmount);
        xp = MathHelper.func_76125_a((int)xp, (int)1, (int)1000);
        this.addXp(xp, player);
    }

    private void addOrLevelSkill(SoulTraits skill, @Nullable PlayerEntity player) {
        Map<SoulTraits, Integer> skills = this.getSkills();
        if (skills.containsKey(skill)) {
            int level = skills.get(skill);
            if (level < skill.getMaxLevel()) {
                skills.put(skill, ++level);
                GearSoul.writeLearnedSkills(skills, this.getTag());
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.skillLearned", new Object[]{skill.getDisplayName(level)}), Util.field_240973_b_);
                }
                return;
            }
            return;
        }
        skills.put(skill, 1);
        GearSoul.writeLearnedSkills(skills, this.getTag());
        if (player != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.skillLearned", new Object[]{skill.getDisplayName(1)}), Util.field_240973_b_);
        }
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<ITextComponent> list, boolean advanced) {
        list.add(1, (ITextComponent)new TranslationTextComponent("misc.silentgems.gear_soul.level", new Object[]{String.valueOf(this.getLevel()), String.format("%,d", this.getXp()), String.format("%,d", this.getXpToNextLevel())}).func_240699_a_(TextFormatting.GREEN));
        if (stack.func_77973_b() instanceof GearSoulItem) {
            list.add(2, this.getElementPairText());
        }
    }

    float getStatModifier(IItemStat stat) {
        String statName = stat.getStatId().func_110623_a();
        return this.getPrimaryElement().getStatModifier(statName) + this.getSecondaryElement().getStatModifier(statName) / 2.0f;
    }

    private ITextComponent getElementPairText() {
        if (this.getSecondaryElement() != SoulElement.NONE) {
            return new TranslationTextComponent("misc.silentgems.gear_soul.elements.pair", new Object[]{this.getPrimaryElement().getDisplayName(), this.getSecondaryElement().getDisplayName()});
        }
        return new TranslationTextComponent("misc.silentgems.gear_soul.elements.single", new Object[]{this.getPrimaryElement().getDisplayName()});
    }

    public static GearSoul construct(ItemStack stack, Iterable<Soul> souls) {
        EnumMap<SoulElement, Integer> elements = new EnumMap<SoulElement, Integer>(SoulElement.class);
        for (Soul soul : souls) {
            if (soul == null) {
                SilentGems.LOGGER.error("Got a null soul when constructing a gear soul", (Throwable)new NullPointerException("soul is null"));
                continue;
            }
            int current = elements.getOrDefault((Object)soul.getPrimaryElement(), 0);
            elements.put(soul.getPrimaryElement(), current + 5);
            if (soul.getSecondaryElement() == SoulElement.NONE) continue;
            current = elements.getOrDefault((Object)soul.getSecondaryElement(), 0);
            elements.put(soul.getSecondaryElement(), current + 3);
        }
        SoulElement primaryElement = GearSoul.selectHighestWeight(elements);
        elements.remove((Object)primaryElement);
        SoulElement secondaryElement = !elements.isEmpty() ? GearSoul.selectHighestWeight(elements) : SoulElement.NONE;
        return new GearSoul(stack, primaryElement, secondaryElement);
    }

    public static GearSoul randomSoul() {
        ArrayList<SoulElement> elements = new ArrayList<SoulElement>();
        for (SoulElement elem : SoulElement.values()) {
            if (elem == SoulElement.NONE) continue;
            elements.add(elem);
        }
        SoulElement primaryElement = (SoulElement)((Object)elements.get(SilentGems.random.nextInt(elements.size())));
        elements.remove((Object)primaryElement);
        elements.add(SoulElement.NONE);
        SoulElement secondaryElement = (SoulElement)((Object)elements.get(SilentGems.random.nextInt(elements.size())));
        return new GearSoul(ItemStack.field_190927_a, primaryElement, secondaryElement);
    }

    private static SoulElement selectHighestWeight(Map<SoulElement, Integer> elements) {
        SoulElement element = SoulElement.NONE;
        int highestWeight = 0;
        for (Map.Entry<SoulElement, Integer> entry : elements.entrySet()) {
            SoulElement elementInMap = entry.getKey();
            int weightInMap = entry.getValue();
            if (weightInMap <= highestWeight && (weightInMap != highestWeight || elementInMap.weight <= element.weight)) continue;
            element = entry.getKey();
            highestWeight = entry.getValue();
        }
        return element;
    }

    public void updateTick(ItemStack tool, PlayerEntity player) {
    }

    public void write(CompoundNBT tags) {
        if (!this.name.isEmpty()) {
            tags.func_74778_a("name", this.name);
        }
        tags.func_74778_a("element1", this.getPrimaryElement().name());
        tags.func_74778_a("element2", this.getSecondaryElement().name());
        tags.func_74768_a("xp", this.getXp());
        tags.func_74768_a("level", this.getLevel());
        GearSoul.writeLearnedSkills(this.getSkills(), tags);
    }

    private static void writeLearnedSkills(Map<SoulTraits, Integer> skills, CompoundNBT tags) {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<SoulTraits, Integer> entry : skills.entrySet()) {
            SoulTraits trait = entry.getKey();
            Integer value = entry.getValue();
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("id", trait.getTraitId().toString());
            tag.func_74777_a("level", value.shortValue());
            tagList.add((Object)tag);
        }
        tags.func_218657_a("skills", (INBT)tagList);
    }

    public String toString() {
        return "GearSoul{Level: " + this.getLevel() + ", XP: " + this.getXp() + ", Elements: {" + this.getPrimaryElement().name() + ", " + this.getSecondaryElement().name() + "}}";
    }
}

