/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.soul.SoulElement;
import net.silentchaos512.gems.network.SyncSoulsPacket;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class Soul {
    private final ResourceLocation id;
    private final SoulElement primaryElement;
    private final SoulElement secondaryElement;
    private final int primaryColor;
    private final int secondaryColor;
    private final float dropRate;
    @Nullable
    private final EntityType<?> entityType;
    private static final Marker MARKER = MarkerManager.getMarker((String)"Souls");
    private static final Map<EntityType<?>, Soul> MAP = new HashMap();
    private static final Map<String, Soul> MAP_BY_ID = new HashMap<String, Soul>();

    private Soul(long seed, EntityType<?> entityType) {
        this.entityType = entityType;
        this.id = Objects.requireNonNull(entityType.getRegistryName());
        SilentGems.LOGGER.debug(MARKER, "Creating soul for {}", (Object)this.id);
        Random random = new Random(seed + (long)entityType.getRegistryName().hashCode());
        this.primaryElement = SoulElement.selectRandom(random);
        SoulElement element2 = SoulElement.selectRandom(random, 0.2f);
        this.secondaryElement = element2 != this.primaryElement ? element2 : SoulElement.NONE;
        this.dropRate = (float)((Double)GemsConfig.Common.soulGemDropRateAverage.get() + (Double)GemsConfig.Common.soulGemDropRateDeviation.get() * random.nextGaussian());
        SpawnEggItem egg = Soul.getSpawnEggForType(entityType);
        if (egg != null) {
            this.primaryColor = Soul.getEggPrimaryColor(egg);
            this.secondaryColor = Soul.getEggSecondaryColor(egg);
        } else {
            this.primaryColor = random.nextInt(0x1000000);
            this.secondaryColor = random.nextInt(0x1000000);
            SilentGems.LOGGER.debug(MARKER, "No spawn egg for {}, setting colors to {} and {}", (Object)this.id, (Object)Color.format((int)this.primaryColor), (Object)Color.format((int)this.secondaryColor));
        }
    }

    public static boolean canHaveSoulGem(EntityType<?> type) {
        return type.func_220339_d() != EntityClassification.MISC;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public SoulElement getPrimaryElement() {
        return this.primaryElement;
    }

    public SoulElement getSecondaryElement() {
        return this.secondaryElement;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Nullable
    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    private Soul(PacketBuffer buffer) {
        this.id = buffer.func_192575_l();
        this.primaryElement = SoulElement.read(buffer);
        this.secondaryElement = SoulElement.read(buffer);
        this.primaryColor = buffer.func_150792_a();
        this.secondaryColor = buffer.func_150792_a();
        this.dropRate = buffer.readFloat();
        this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.id);
    }

    public static Soul read(PacketBuffer buffer) {
        return new Soul(buffer);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.id);
        this.primaryElement.write(buffer);
        this.secondaryElement.write(buffer);
        buffer.func_150787_b(this.primaryColor);
        buffer.func_150787_b(this.secondaryColor);
        buffer.writeFloat(this.dropRate);
    }

    public static void handleSyncPacket(SyncSoulsPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        MAP_BY_ID.clear();
        packet.getSouls().forEach(soul -> {
            MAP.put(soul.entityType, (Soul)soul);
            MAP_BY_ID.put(soul.id.toString(), (Soul)soul);
        });
        SilentGems.LOGGER.info("Received {} soul info objects from server", (Object)MAP.size());
        context.get().setPacketHandled(true);
    }

    @Nullable
    private static SpawnEggItem getSpawnEggForType(EntityType<?> entityType) {
        for (SpawnEggItem egg : SpawnEggItem.func_195985_g()) {
            if (egg.func_208076_b(null) != entityType) continue;
            return egg;
        }
        return null;
    }

    private static int getEggPrimaryColor(SpawnEggItem egg) {
        Integer i = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"field_195988_c");
        return i != null ? i : 0xFF00FF;
    }

    private static int getEggSecondaryColor(SpawnEggItem egg) {
        Integer i = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"field_195989_d");
        return i != null ? i : 0;
    }

    public float getDropRate(LivingEntity entity) {
        if (!entity.func_184222_aU()) {
            return ((Double)GemsConfig.Common.soulGemDropRateBoss.get()).floatValue();
        }
        if (entity instanceof SlimeEntity) {
            return this.dropRate / 2.0f;
        }
        return this.dropRate;
    }

    public float getBaseDropRate() {
        return this.dropRate;
    }

    public ItemStack getSoulGem() {
        return SoulGemItem.getStack(this);
    }

    public ITextComponent getEntityName() {
        return new TranslationTextComponent("entity." + this.id.func_110624_b() + "." + this.id.func_110623_a());
    }

    @Nullable
    public static Soul from(LivingEntity entity) {
        return MAP.get(entity.func_200600_R());
    }

    @Nullable
    public static Soul from(ResourceLocation id) {
        return Soul.from(id.toString());
    }

    @Nullable
    public static Soul from(String id) {
        return MAP_BY_ID.get(id);
    }

    public static Collection<Soul> getValues() {
        return MAP.values();
    }

    public static final class Events {
        public static final Events INSTANCE = new Events();

        private Events() {
        }

        @SubscribeEvent
        public void onServerAboutToStart(FMLServerStartingEvent event) {
            MAP.clear();
            long seed = Events.calculateSeed(event);
            for (EntityType entityType : ForgeRegistries.ENTITIES.getValues()) {
                if (!Soul.canHaveSoulGem(entityType)) continue;
                Soul soul = new Soul(seed, entityType);
                MAP.put(entityType, soul);
                ResourceLocation id = Objects.requireNonNull(entityType.getRegistryName());
                MAP_BY_ID.put(id.toString(), soul);
            }
        }

        @SubscribeEvent
        public void onLivingDrops(LivingDropsEvent event) {
            LivingEntity entity = event.getEntityLiving();
            Soul soul = Soul.from(entity);
            if (soul != null && Events.shouldDropSoulGem(event, entity, soul)) {
                ItemStack soulGem = soul.getSoulGem();
                ItemEntity entityItem = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), soulGem);
                event.getDrops().add(entityItem);
            }
        }

        private static boolean shouldDropSoulGem(LivingDropsEvent event, LivingEntity entity, @Nonnull Soul soul) {
            boolean killedByPlayer = event.getSource().func_76346_g() instanceof PlayerEntity;
            float dropRate = soul.getDropRate(entity);
            float lootingBonus = dropRate * (float)event.getLootingLevel() / 5.0f;
            return killedByPlayer && MathUtils.tryPercentage((double)(dropRate + lootingBonus));
        }

        private static long calculateSeed(FMLServerStartingEvent event) {
            String configSeed = (String)GemsConfig.Common.soulGemElementSeed.get();
            if (!configSeed.isEmpty()) {
                return configSeed.hashCode();
            }
            MinecraftServer server = event.getServer();
            if (server instanceof DedicatedServer) {
                DedicatedServer dedicatedServer = (DedicatedServer)server;
                return dedicatedServer.func_213221_d_().field_241082_U_.func_236221_b_();
            }
            if (server instanceof IntegratedServer) {
                IntegratedServer integratedServer = (IntegratedServer)server;
                integratedServer.func_240793_aU_().func_230418_z_().func_236221_b_();
            }
            return 0L;
        }
    }
}

