/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.loot.modifier;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsTraits;

public class ImperialTraitLootModifier
extends LootModifier {
    private static final float BASE_CHANCE = 0.1f;

    public ImperialTraitLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(generatedLoot);
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool != null) {
            int traitLevel = TraitHelper.getTraitLevel((ItemStack)tool, (ResourceLocation)GemsTraits.IMPERIAL);
            generatedLoot.forEach(s -> {
                ItemStack stack = ImperialTraitLootModifier.tryApply(s, traitLevel);
                if (!stack.func_190926_b()) {
                    ret.add(stack);
                }
            });
        }
        return ret;
    }

    private static ItemStack tryApply(ItemStack stack, int traitLevel) {
        if (SilentGems.random.nextFloat() < 0.1f * (float)traitLevel && stack.func_77973_b().func_206844_a((ITag)Tags.Items.GEMS)) {
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ImperialTraitLootModifier> {
        public ImperialTraitLootModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            return new ImperialTraitLootModifier(conditionsIn);
        }

        public JsonObject write(ImperialTraitLootModifier instance) {
            return new JsonObject();
        }
    }
}

