/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.loot.modifier;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.Skulls;
import net.silentchaos512.gems.lib.soul.SoulTraits;

public class SkullCollectorTraitLootModifier
extends LootModifier {
    public SkullCollectorTraitLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        int level = TraitHelper.getTraitLevel((ItemStack)SkullCollectorTraitLootModifier.getItemUsed(context), (ResourceLocation)SoulTraits.SKULL_COLLECTOR);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(generatedLoot);
        if (entity instanceof LivingEntity) {
            ItemStack skull;
            float dropRate = (float)level * Skulls.getDropRate((LivingEntity)entity);
            if (SilentGems.random.nextFloat() < dropRate && !(skull = Skulls.getSkull((LivingEntity)entity)).func_190926_b()) {
                ret.add(skull);
            }
        }
        return ret;
    }

    private static ItemStack getItemUsed(LootContext context) {
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool != null && !tool.func_190926_b()) {
            return tool;
        }
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216284_d);
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_184614_ca();
        }
        return ItemStack.field_190927_a;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SkullCollectorTraitLootModifier> {
        public SkullCollectorTraitLootModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            return new SkullCollectorTraitLootModifier(conditionsIn);
        }

        public JsonObject write(SkullCollectorTraitLootModifier instance) {
            return new JsonObject();
        }
    }
}

