/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.chaosbuff.ChaosBuffManager;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.network.GeneralSyncPacket;
import net.silentchaos512.gems.network.LoginPacket;
import net.silentchaos512.gems.network.SpawnEntityPacket;
import net.silentchaos512.gems.network.SyncChaosBuffsPacket;
import net.silentchaos512.gems.network.SyncSoulsPacket;

public final class Network {
    private static final ResourceLocation NAME = SilentGems.getId("network");
    public static SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)NAME).clientAcceptedVersions(s -> Objects.equals(s, "1")).serverAcceptedVersions(s -> Objects.equals(s, "1")).networkProtocolVersion(() -> "1").simpleChannel();

    private Network() {
    }

    public static void init() {
    }

    static {
        channel.messageBuilder(GeneralSyncPacket.class, 1).decoder(GeneralSyncPacket::fromBytes).encoder(GeneralSyncPacket::toBytes).consumer(GeneralSyncPacket::handle).add();
        channel.messageBuilder(SyncSoulsPacket.class, 2).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncSoulsPacket::fromBytes).encoder(SyncSoulsPacket::toBytes).markAsLoginPacket().consumer(FMLHandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            Soul.handleSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(SyncChaosBuffsPacket.class, 3).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncChaosBuffsPacket::fromBytes).encoder(SyncChaosBuffsPacket::toBytes).markAsLoginPacket().consumer(FMLHandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            ChaosBuffManager.handlePacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(SpawnEntityPacket.class, 4).decoder(SpawnEntityPacket::decode).encoder(SpawnEntityPacket::encode).consumer(SpawnEntityPacket::handle).add();
        channel.messageBuilder(LoginPacket.Reply.class, 5).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(buffer -> new LoginPacket.Reply()).encoder((msg, buffer) -> {}).consumer(FMLHandshakeHandler.indexFirst((hh, msg, ctx) -> msg.handle((Supplier<NetworkEvent.Context>)ctx))).add();
    }
}

