/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.lib.soul.GearSoul;
import net.silentchaos512.gems.lib.soul.GearSoulPart;

public final class SoulManager {
    private static final String NBT_SOUL = "SG_GearSoul";
    static final Map<UUID, GearSoul> SOULS = new HashMap<UUID, GearSoul>();

    private SoulManager() {
    }

    @Nullable
    public static GearSoul getSoul(ItemStack gearOrSoul) {
        if (!gearOrSoul.func_190926_b()) {
            if (GearHelper.isGear((ItemStack)gearOrSoul)) {
                return SoulManager.getSoulFromGear(gearOrSoul);
            }
            if (gearOrSoul.func_77973_b() instanceof GearSoulItem) {
                return SoulManager.getSoulFromItem(gearOrSoul);
            }
        }
        return null;
    }

    @Nullable
    private static GearSoul getSoulFromGear(ItemStack gear) {
        if (!(GearData.hasPartOfType((ItemStack)gear, (PartType)GearSoulPart.TYPE) && gear.func_77942_o() && gear.func_196082_o().func_74764_b(NBT_SOUL))) {
            return null;
        }
        return SoulManager.getSoulFromItem(gear);
    }

    private static GearSoul getSoulFromItem(ItemStack soulItem) {
        return new GearSoul(soulItem);
    }

    public static void setSoul(ItemStack gear, GearSoul soul) {
        CompoundNBT tags = new CompoundNBT();
        soul.write(tags);
        gear.func_196082_o().func_218657_a(NBT_SOUL, (INBT)tags);
    }

    public static void addSoulXp(int amount, ItemStack gear, @Nullable PlayerEntity player) {
        GearSoul soul = SoulManager.getSoul(gear);
        if (soul != null && amount > 0) {
            soul.addXp(amount, player);
        }
    }
}

