/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.world.GemsWorldFeatures;
import net.silentchaos512.gems.world.feature.IRegionalGemsConfig;

public class RegionalGemsFeatureConfig
implements IFeatureConfig,
IRegionalGemsConfig {
    public static final Codec<RegionalGemsFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Gems.Set.CODEC.fieldOf("gem_set").forGetter(config -> config.gemSet), (App)Codec.INT.fieldOf("size").forGetter(config -> config.size), (App)Codec.INT.fieldOf("region_size").forGetter(config -> config.regionSize), (App)RuleTest.field_237127_c_.fieldOf("target").forGetter(config -> config.target)).apply((Applicative)instance, RegionalGemsFeatureConfig::new));
    protected final Gems.Set gemSet;
    public final int size;
    public final int regionSize;
    public final RuleTest target;

    public RegionalGemsFeatureConfig(Gems.Set gemSet, int size, int regionSize) {
        this(gemSet, size, regionSize, (RuleTest)new TagMatchRuleTest(GemsWorldFeatures.getOreGenTargetBlock(gemSet)));
    }

    public RegionalGemsFeatureConfig(Gems.Set gemSet, int size, int regionSize, RuleTest target) {
        this.gemSet = gemSet;
        this.size = size;
        this.regionSize = regionSize;
        this.target = target;
    }

    @Nullable
    public Gems selectGem(ISeedReader world, BlockPos pos, Random random) {
        return this.selectGem(world, pos, random, this.gemSet, this.regionSize);
    }
}

