/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.world.feature.RegionalGlowrosesFeatureConfig;

public class RegionalGlowrosesFeature
extends FlowersFeature<RegionalGlowrosesFeatureConfig> {
    public RegionalGlowrosesFeature(Codec<RegionalGlowrosesFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator chunkGenerator, Random random, BlockPos pos, RegionalGlowrosesFeatureConfig config) {
        if (config.regionSize < 1) {
            return false;
        }
        BlockState blockstate = this.getFlowerToPlace(worldIn, random, pos, config);
        int i = 0;
        if (blockstate != null) {
            for (int j = 0; j < this.getFlowerCount(config); ++j) {
                BlockPos blockpos = this.getNearbyPos(random, pos, config);
                if (!worldIn.func_175623_d(blockpos) || blockpos.func_177956_o() >= 255 || !blockstate.func_196955_c((IWorldReader)worldIn, blockpos) || !this.isValidPosition((IWorld)worldIn, blockpos, config)) continue;
                worldIn.func_180501_a(blockpos, blockstate, 2);
                ++i;
            }
        }
        return i > 0;
    }

    public boolean isValidPosition(IWorld world, BlockPos pos, RegionalGlowrosesFeatureConfig config) {
        return !config.blacklist.contains(world.func_180495_p(pos));
    }

    public int getFlowerCount(RegionalGlowrosesFeatureConfig config) {
        return config.tryCount;
    }

    public BlockPos getNearbyPos(Random rand, BlockPos pos, RegionalGlowrosesFeatureConfig config) {
        return pos.func_177982_a(rand.nextInt(config.xSpread) - rand.nextInt(config.xSpread), rand.nextInt(config.ySpread) - rand.nextInt(config.ySpread), rand.nextInt(config.zSpread) - rand.nextInt(config.zSpread));
    }

    @Deprecated
    public BlockState getFlowerToPlace(Random rand, BlockPos pos, RegionalGlowrosesFeatureConfig config) {
        throw new IllegalAccessError("call to incorrect getFlowerToPlace");
    }

    @Nullable
    public BlockState getFlowerToPlace(ISeedReader world, Random rand, BlockPos pos, RegionalGlowrosesFeatureConfig config) {
        Gems gem = config.selectGem(world, pos, rand);
        if (gem != null) {
            return gem.getGlowrose().func_176223_P();
        }
        return null;
    }
}

