/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryLocator {
    private BlockPos inventoryCoordinate = null;
    private Direction inventorySide = null;

    @Nonnull
    private LazyOptional<IItemHandler> getItemHandlerAtDirection(World worldObj, BlockPos thisCoordinate, Direction direction) {
        if (direction == null) {
            if (this.inventoryCoordinate != null) {
                return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
            }
            return LazyOptional.empty();
        }
        TileEntity te = worldObj.func_175625_s(thisCoordinate);
        if (te == null) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).map(handler -> {
            this.inventoryCoordinate = thisCoordinate.func_177972_a(direction);
            this.inventorySide = direction.func_176734_d();
            return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
        }).orElse(LazyOptional.empty());
    }

    @Nonnull
    private LazyOptional<IItemHandler> getItemHandlerAtCoordinate(World worldObj, BlockPos c, Direction direction) {
        TileEntity te = worldObj.func_175625_s(c);
        if (te == null) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
    }

    public void ejectStack(World worldObj, BlockPos pos, ItemStack stack, BlockPos thisCoordinate, Direction[] directions) {
        for (Direction dir : directions) {
            if (stack.func_190926_b()) break;
            ItemStack finalStack = stack;
            stack = this.getItemHandlerAtDirection(worldObj, thisCoordinate, dir).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)finalStack, (boolean)false)).orElse(stack);
        }
        if (!stack.func_190926_b()) {
            ItemEntity entityItem = new ItemEntity(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            worldObj.func_217376_c((Entity)entityItem);
        }
    }

    public Direction getInventorySide() {
        return this.inventorySide;
    }
}

