/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multiblock;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.IMultiblockFixer;
import mcjty.lib.multiblock.MultiblockHolder;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiblockDriver<T extends IMultiblock> {
    private final Map<Integer, MultiblockHolder<T>> multiblocks = new HashMap<Integer, MultiblockHolder<T>>();
    private int lastId = 0;
    private final Function<CompoundNBT, T> loader;
    private final BiConsumer<CompoundNBT, T> saver;
    private final Consumer<MultiblockDriver<T>> dirtySetter;
    private final BiPredicate<T, T> mergeChecker;
    private final IMultiblockFixer<T> fixer;
    private final BiFunction<World, BlockPos, IMultiblockConnector> holderGetter;

    private MultiblockDriver(Builder<T> builder) {
        this.loader = ((Builder)builder).loader;
        this.saver = ((Builder)builder).saver;
        this.dirtySetter = ((Builder)builder).dirtySetter;
        this.mergeChecker = ((Builder)builder).mergeChecker;
        this.fixer = ((Builder)builder).fixer;
        this.holderGetter = ((Builder)builder).holderGetter;
    }

    public void clear() {
        this.multiblocks.clear();
        this.lastId = 0;
    }

    public IMultiblockFixer<T> getFixer() {
        return this.fixer;
    }

    public BiFunction<World, BlockPos, IMultiblockConnector> getHolderGetter() {
        return this.holderGetter;
    }

    public BiPredicate<T, T> getMergeChecker() {
        return this.mergeChecker;
    }

    public void createOrUpdate(int id, T mb) {
        this.multiblocks.put(id, new MultiblockHolder<T>(mb));
    }

    @Nullable
    public T get(int id) {
        MultiblockHolder<T> holder = this.multiblocks.get(id);
        return holder == null ? null : (T)holder.getMb();
    }

    public void delete(int id) {
        this.multiblocks.remove(id);
        this.dirtySetter.accept(this);
    }

    public void modify(int id, Consumer<MultiblockHolder<T>> consumer) {
        MultiblockHolder<T> holder = this.multiblocks.get(id);
        if (holder != null) {
            consumer.accept(holder);
            this.dirtySetter.accept(this);
        }
    }

    public int createId() {
        ++this.lastId;
        this.dirtySetter.accept(this);
        return this.lastId;
    }

    public void load(CompoundNBT tagCompound) {
        this.clear();
        ListNBT lst = tagCompound.func_150295_c("mb", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("id");
            IMultiblock value = (IMultiblock)this.loader.apply(tc);
            MultiblockHolder<IMultiblock> holder = new MultiblockHolder<IMultiblock>(value);
            holder.load(tc);
            this.multiblocks.put(id, holder);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public CompoundNBT save(CompoundNBT tagCompound) {
        ListNBT lst = new ListNBT();
        for (Map.Entry<Integer, MultiblockHolder<T>> entry : this.multiblocks.entrySet()) {
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("id", entry.getKey().intValue());
            this.saver.accept(tc, (CompoundNBT)entry.getValue().getMb());
            entry.getValue().save(tc);
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("mb", (INBT)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static <T extends IMultiblock> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends IMultiblock> {
        private Function<CompoundNBT, T> loader;
        private BiConsumer<CompoundNBT, T> saver;
        private Consumer<MultiblockDriver<T>> dirtySetter;
        private BiPredicate<T, T> mergeChecker;
        private IMultiblockFixer<T> fixer;
        private BiFunction<World, BlockPos, IMultiblockConnector> holderGetter;

        public Builder<T> loader(Function<CompoundNBT, T> loader) {
            this.loader = loader;
            return this;
        }

        public Builder<T> saver(BiConsumer<CompoundNBT, T> saver) {
            this.saver = saver;
            return this;
        }

        public Builder<T> dirtySetter(Consumer<MultiblockDriver<T>> dirtySetter) {
            this.dirtySetter = dirtySetter;
            return this;
        }

        public Builder<T> mergeChecker(BiPredicate<T, T> mergeChecker) {
            this.mergeChecker = mergeChecker;
            return this;
        }

        public Builder<T> fixer(IMultiblockFixer<T> fixer) {
            this.fixer = fixer;
            return this;
        }

        public Builder<T> holderGetter(BiFunction<World, BlockPos, IMultiblockConnector> holderGetter) {
            this.holderGetter = holderGetter;
            return this;
        }

        public MultiblockDriver<T> build() {
            return new MultiblockDriver(this);
        }
    }
}

