/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.syncpositional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.syncpositional.IPositionalData;
import mcjty.lib.syncpositional.PacketSendPositionalDataToClients;
import mcjty.lib.syncpositional.PositionalDataKey;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class PositionalDataSyncer {
    private final Map<ResourceLocation, Function<PacketBuffer, IPositionalData>> factories = new HashMap<ResourceLocation, Function<PacketBuffer, IPositionalData>>();
    private final Map<ResourceLocation, BiConsumer<GlobalPos, IPositionalData>> clientHandlers = new HashMap<ResourceLocation, BiConsumer<GlobalPos, IPositionalData>>();
    private final Map<ChunkPos, Map<PositionalDataKey, Runnable>> watchHandlers = Collections.synchronizedMap(new HashMap());
    private final Map<PositionalDataKey, IPositionalData> syncTodo = new HashMap<PositionalDataKey, IPositionalData>();
    private int timeout = 0;

    public void registerPositionalDataFactory(ResourceLocation id, Function<PacketBuffer, IPositionalData> factory) {
        this.factories.put(id, factory);
    }

    public void registerClientHandler(ResourceLocation id, BiConsumer<GlobalPos, IPositionalData> handler) {
        this.clientHandlers.put(id, handler);
    }

    public void registerWatchHandler(ResourceLocation id, GlobalPos pos, Runnable handler) {
        ChunkPos cp = new ChunkPos(pos.func_218180_b());
        Map runnableMap = this.watchHandlers.computeIfAbsent(cp, chunkPos -> new HashMap());
        PositionalDataKey dataKey = new PositionalDataKey(id, pos);
        runnableMap.put(dataKey, handler);
    }

    public void unregisterWatchHandler(ResourceLocation id, GlobalPos pos) {
        ChunkPos cp = new ChunkPos(pos.func_218180_b());
        Map<PositionalDataKey, Runnable> runnableMap = this.watchHandlers.get(cp);
        if (runnableMap != null) {
            runnableMap.remove(new PositionalDataKey(id, pos));
        }
    }

    @Nullable
    public IPositionalData create(ResourceLocation id, PacketBuffer buf) {
        return this.factories.getOrDefault(id, b -> null).apply(buf);
    }

    public <T extends IPositionalData> void handle(GlobalPos pos, T data) {
        this.clientHandlers.getOrDefault(data.getId(), (p, d) -> {}).accept(pos, data);
    }

    public void publish(World world, BlockPos pos, IPositionalData data) {
        PositionalDataKey key = new PositionalDataKey(data.getId(), GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos));
        this.syncTodo.put(key, data);
    }

    public void forget(World world, BlockPos pos, ResourceLocation id) {
        PositionalDataKey key = new PositionalDataKey(id, GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos));
        this.syncTodo.remove(key);
    }

    public void sendOutData(MinecraftServer server) {
        --this.timeout;
        if (this.timeout < 0) {
            this.timeout = 10;
            for (Map.Entry<PositionalDataKey, IPositionalData> entry : this.syncTodo.entrySet()) {
                GlobalPos pos = entry.getKey().getPos();
                McJtyLib.networkHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> {
                    ServerWorld level = server.func_71218_a(pos.func_239646_a_());
                    return (Chunk)level.func_217349_x(pos.func_218180_b());
                }), (Object)new PacketSendPositionalDataToClients(pos, entry.getValue()));
            }
            this.syncTodo.clear();
        }
    }

    public void startWatching(ServerPlayerEntity player) {
        BlockPos blockPos = player.func_233580_cy_();
        ChunkPos cp = new ChunkPos(blockPos);
        Map<PositionalDataKey, Runnable> runnableMap = this.watchHandlers.get(cp);
        if (runnableMap != null) {
            GlobalPos pos = GlobalPos.func_239648_a_((RegistryKey)player.field_70170_p.func_234923_W_(), (BlockPos)blockPos);
            for (Map.Entry<PositionalDataKey, Runnable> entry : runnableMap.entrySet()) {
                if (!pos.equals((Object)entry.getKey().getPos())) continue;
                entry.getValue().run();
            }
        }
    }
}

