/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.advancement;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.advancement.ITriggerable;
import ovh.corail.tombstone.advancement.StatelessCriterion;

public class AbstractTrigger<T extends StatelessCriterion>
implements ICriterionTrigger<T>,
ITriggerable {
    private final Map<PlayerAdvancements, Set<ICriterionTrigger.Listener<T>>> listeners = Maps.newIdentityHashMap();
    private final ResourceLocation rl;
    private final BiFunction<JsonObject, ConditionArrayParser, T> factory;

    public AbstractTrigger(String name, BiFunction<JsonObject, ConditionArrayParser, T> factory) {
        this(new ResourceLocation("tombstone", name), factory);
    }

    public AbstractTrigger(ResourceLocation rl, BiFunction<JsonObject, ConditionArrayParser, T> factory) {
        this.rl = rl;
        this.factory = factory;
    }

    public ResourceLocation func_192163_a() {
        return this.rl;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<T> listener) {
        this.listeners.computeIfAbsent(playerAdvancements, advancements -> Sets.newHashSet()).add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<T> listener) {
        Set<ICriterionTrigger.Listener<T>> set = this.listeners.get(playerAdvancements);
        if (set != null && set.remove(listener) && set.isEmpty()) {
            this.listeners.remove(playerAdvancements);
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public T createInstance(JsonObject json, ConditionArrayParser conditionsParser) {
        return (T)((StatelessCriterion)this.factory.apply(json, conditionsParser));
    }

    @Override
    public void trigger(ServerPlayerEntity player) {
        this.trigger(player, instance -> true);
    }

    public void trigger(ServerPlayerEntity player, Predicate<T> predic) {
        PlayerAdvancements playeradvancements = player.func_192039_O();
        Set<ICriterionTrigger.Listener<T>> set = this.listeners.get(playeradvancements);
        if (set != null && !set.isEmpty()) {
            List<ICriterionTrigger.Listener> list = set.stream().filter(l -> predic.test(l.func_192158_a())).collect(Collectors.toList());
            list.forEach(l -> l.func_192159_a(playeradvancements));
        }
    }
}

