/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class BlockGrave
extends BlockGraveBase<TileEntityPlayerGrave> {
    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    @Override
    protected TileEntityPlayerGrave createTileGrave(BlockState state, IBlockReader world) {
        return new TileEntityPlayerGrave();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (!world.func_201670_d()) {
            return this.activatePlayerGrave(world, pos, state, (ServerPlayerEntity)player) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    private boolean activatePlayerGrave(World world, BlockPos pos, BlockState state, ServerPlayerEntity player) {
        if (world.func_201670_d()) {
            return true;
        }
        TileEntityPlayerGrave grave = (TileEntityPlayerGrave)((Object)this.getTileEntity(world, pos));
        if (grave == null || grave.countTicks < 30 || !player.func_70089_S()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((PlayerEntity)player, grave);
        boolean isOwner = grave.isOwner((PlayerEntity)player);
        if (!hasKey && isOwner) {
            ModTriggers.EASY_OPENING.trigger(player);
        }
        boolean isTombRaiding = false;
        if (hasKey || isOwner || (isTombRaiding = !grave.getNeedAccess())) {
            grave.giveInventory(player);
            if (world.func_72912_H().func_176130_y() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get() > 0 && Helper.RANDOM.nextInt(100) <= (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.RANDOM.nextInt(3) + 1).forEach(i -> Helper.spawnRandomMob((ServerWorld)world, pos));
            }
            if (isTombRaiding) {
                ModTriggers.TOMB_RAIDING.trigger(player);
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsPlunderPlayerGrave.get()));
                LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
            }
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendMessage((PlayerEntity)player, new Object[0]);
        }
        return true;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        ServerPlayerEntity player;
        if (!world.func_201670_d() && entity.func_225608_bj_() && entity.func_70089_S() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && PlayerPreference.get((PlayerEntity)(player = (ServerPlayerEntity)entity)).activateGraveBySneaking() && this.activatePlayerGrave(world, pos, state, player)) {
            ModTriggers.SNEAK_GRAVE.trigger(player);
        }
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader blockGetter, BlockPos pos) {
        return 0.0f;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        return null;
    }

    @Override
    protected void onDrop(World world, BlockPos pos, BlockState oldState) {
        Optional.ofNullable(this.getTileEntity(world, pos)).ifPresent(grave -> {
            for (int i = 0; i < grave.getInventory().getSlots(); ++i) {
                ItemStack stack = grave.getInventory().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)grave.getInventory().extractItem(i, stack.func_190916_E(), false));
            }
        });
    }

    public ItemStack asDecorativeStack() {
        Item item;
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName.func_110624_b(), "decorative_" + registryName.func_110623_a()))) != null && item != Items.field_190931_a) {
            return new ItemStack((IItemProvider)item);
        }
        return ItemStack.field_190927_a;
    }

    private static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 1.8E7f).func_235838_a_(s -> 5).func_200947_a(SoundType.field_185851_d);
    }
}

