/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.CMessageProtection;
import ovh.corail.tombstone.network.PacketHandler;

public class ProtectedEntityImpl
implements IProtectedEntity {
    protected boolean active = false;
    private final Function<LivingEntity, GlobalPos> defaultSafeLocation = entity -> GlobalPos.func_239648_a_((RegistryKey)entity.field_70170_p.func_234923_W_(), (BlockPos)entity.func_233580_cy_().func_177982_a(Helper.getRandom(-50, 50), 0, Helper.getRandom(-50, 50)));
    protected final Function<LivingEntity, Optional<GlobalPos>> safeLocation;
    private static final String ACTIVE = "active";

    public ProtectedEntityImpl() {
        this.safeLocation = entity -> Optional.empty();
    }

    public ProtectedEntityImpl(Function<LivingEntity, Optional<GlobalPos>> safeLocation) {
        this.safeLocation = safeLocation;
    }

    @Override
    public void apply(LivingEntity entity, boolean active) {
        this.active = active;
        if (!entity.field_70170_p.func_201670_d()) {
            PacketHandler.sendToAllTrackingPlayers(new CMessageProtection(entity.func_145782_y(), active), entity);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public GlobalPos getSafeLocation(LivingEntity entity) {
        return this.safeLocation.apply(entity).orElse(this.defaultSafeLocation.apply(entity));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a(ACTIVE, this.active);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b(ACTIVE, 1)) {
            this.active = nbt.func_74767_n(ACTIVE);
        }
    }
}

