/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import ovh.corail.tombstone.api.capability.IServantEntity;
import ovh.corail.tombstone.entity.ai.FollowOwnerGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.entity.ai.spell.BuffOtherSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.CurseSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.FangsSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.FireBallSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.HealSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.ScorchSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SelfBuffSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellCastingGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.entity.ai.spell.ThunderSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.WitherSkullSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.WololoSpellGoal;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;

public class ServantEntityImpl
implements IServantEntity {
    @Nullable
    protected UUID ownerId = null;
    protected CasterType casterType = CasterType.getDefault();
    private static final String CASTER_TYPE = "caster_type";
    private static final String SERVANT_OWNER_ID = "servant_owner_id";

    @Override
    public Optional<UUID> getOwnerId() {
        return Optional.ofNullable(this.ownerId);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public boolean isSpellCaster() {
        return this.getCasterType() != CasterType.NONE.ordinal();
    }

    @Override
    public int getCasterType() {
        return this.casterType.ordinal();
    }

    @Override
    public void setSpellCaster(int casterType) {
        this.casterType = CasterType.byId(casterType);
    }

    @Override
    public void setAI(CreatureEntity servant) {
        servant.func_110163_bv();
        servant.func_98053_h(true);
        EntityHelper.resetAttackAction((LivingEntity)servant);
        servant.field_70714_bg.field_220892_d.removeIf(g -> !(g.func_220772_j() instanceof MeleeAttackGoal) && !(g.func_220772_j() instanceof RangedAttackGoal) && !(g.func_220772_j() instanceof RangedBowAttackGoal) && !(g.func_220772_j() instanceof RangedCrossbowAttackGoal) && !(g.func_220772_j() instanceof SpellCastingGoal) && !(g.func_220772_j() instanceof SpellUseGoal));
        servant.field_70715_bh.field_220892_d.clear();
        servant.func_213375_cj().field_218232_c.clear();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            servant.func_233663_d_(slot);
        }
        servant.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)servant));
        servant.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((MobEntity)servant, 1.0, 10.0f, 2.5f, false){

            @Override
            protected Optional<PlayerEntity> getOwner() {
                return EntityHelper.getServantOwner((Entity)this.mob);
            }
        });
        servant.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal(servant, 1.0));
        servant.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)servant, PlayerEntity.class, 8.0f));
        servant.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)servant));
        servant.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((MobEntity)servant){

            @Override
            protected Optional<PlayerEntity> getOwner() {
                return EntityHelper.getServantOwner((Entity)this.field_75299_d);
            }
        });
        servant.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((MobEntity)servant){

            @Override
            protected Optional<PlayerEntity> getOwner() {
                return EntityHelper.getServantOwner((Entity)this.field_75299_d);
            }
        });
        servant.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal(servant, new Class[0]));
        if (this.isSpellCaster() && servant.field_70714_bg.field_220892_d.stream().noneMatch(g -> g.func_220772_j() instanceof SpellCastingGoal)) {
            servant.field_70714_bg.func_75776_a(1, (Goal)new SpellCastingGoal(servant));
            switch (this.casterType) {
                case DARKNESS: {
                    servant.field_70714_bg.func_75776_a(2, (Goal)new SelfBuffSpellGoal(servant, new EffectInstance(ModEffects.unstable_intangibility, 2400)));
                    servant.field_70714_bg.func_75776_a(3, (Goal)new BuffOtherSpellGoal(servant, new EffectInstance(ModEffects.unstable_intangibility, 2400)));
                    servant.field_70714_bg.func_75776_a(4, (Goal)new CurseSpellGoal(servant, new EffectInstance(Effects.field_82731_v, 200)));
                    servant.field_70714_bg.func_75776_a(5, (Goal)new WitherSkullSpellGoal(servant));
                    servant.field_70714_bg.func_75776_a(6, (Goal)new WololoSpellGoal(servant, DyeColor.BLACK));
                    break;
                }
                case LIGHTNING: {
                    servant.field_70714_bg.func_75776_a(2, (Goal)new SelfBuffSpellGoal(servant, new EffectInstance(ModEffects.lightning_resistance, 2400)));
                    servant.field_70714_bg.func_75776_a(3, (Goal)new BuffOtherSpellGoal(servant, new EffectInstance(ModEffects.lightning_resistance, 2400)));
                    servant.field_70714_bg.func_75776_a(4, (Goal)new CurseSpellGoal(servant, new EffectInstance(Effects.field_188424_y, 200)));
                    servant.field_70714_bg.func_75776_a(5, (Goal)new ThunderSpellGoal(servant));
                    servant.field_70714_bg.func_75776_a(6, (Goal)new WololoSpellGoal(servant, DyeColor.BLUE));
                    break;
                }
                case FIRE: {
                    servant.field_70714_bg.func_75776_a(2, (Goal)new SelfBuffSpellGoal(servant, new EffectInstance(Effects.field_76426_n, 2400, 3)));
                    servant.field_70714_bg.func_75776_a(3, (Goal)new BuffOtherSpellGoal(servant, new EffectInstance(Effects.field_76426_n, 2400, 3)));
                    servant.field_70714_bg.func_75776_a(4, (Goal)new ScorchSpellGoal(servant));
                    servant.field_70714_bg.func_75776_a(5, (Goal)new FireBallSpellGoal(servant));
                    servant.field_70714_bg.func_75776_a(6, (Goal)new WololoSpellGoal(servant, DyeColor.ORANGE));
                    break;
                }
                case FROST: {
                    servant.field_70714_bg.func_75776_a(2, (Goal)new SelfBuffSpellGoal(servant, new EffectInstance(ModEffects.frost_resistance, 2400)));
                    servant.field_70714_bg.func_75776_a(3, (Goal)new BuffOtherSpellGoal(servant, new EffectInstance(ModEffects.frost_resistance, 2400)));
                    servant.field_70714_bg.func_75776_a(4, (Goal)new CurseSpellGoal(servant, new EffectInstance(Effects.field_76421_d, 200)));
                    servant.field_70714_bg.func_75776_a(5, (Goal)new CurseSpellGoal(servant, new EffectInstance(Effects.field_76436_u, 200, 2)));
                    servant.field_70714_bg.func_75776_a(6, (Goal)new WololoSpellGoal(servant, DyeColor.WHITE));
                    break;
                }
                case EARTH: {
                    servant.field_70714_bg.func_75776_a(2, (Goal)new SelfBuffSpellGoal(servant, new EffectInstance(Effects.field_76429_m, 2400, 2)));
                    servant.field_70714_bg.func_75776_a(3, (Goal)new BuffOtherSpellGoal(servant, new EffectInstance(Effects.field_76429_m, 2400, 2)));
                    servant.field_70714_bg.func_75776_a(4, (Goal)new CurseSpellGoal(servant, new EffectInstance(Effects.field_76437_t, 200)));
                    servant.field_70714_bg.func_75776_a(5, (Goal)new FangsSpellGoal(servant));
                    servant.field_70714_bg.func_75776_a(6, (Goal)new WololoSpellGoal(servant, DyeColor.GREEN));
                    break;
                }
            }
            servant.field_70714_bg.func_75776_a(6, (Goal)new HealSpellGoal(servant));
        }
        servant.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal<MobEntity>((MobEntity)servant, MobEntity.class, 20, true, false, target -> target instanceof IMob && !servant.func_184191_r((Entity)target)){

            protected double func_111175_f() {
                return 7.0;
            }
        });
        if (Optional.ofNullable(servant.func_184102_h()).map(MinecraftServer::func_71219_W).orElse(false).booleanValue()) {
            servant.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)servant, PlayerEntity.class, 20, true, false, target -> EntityHelper.isValidPlayer((Entity)target) && !servant.func_184191_r((Entity)target)){

                protected double func_111175_f() {
                    return 5.0;
                }
            });
        }
        CallbackHandler.addFastCallback(() -> this.getOwnerId().ifPresent(ownerId -> PacketHandler.sendToAllTrackingPlayers(new CMessageServant(servant.func_145782_y(), (UUID)ownerId, true), (LivingEntity)servant)));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.ownerId != null) {
            nbt.func_186854_a(SERVANT_OWNER_ID, this.ownerId);
        }
        nbt.func_74777_a(CASTER_TYPE, (short)this.casterType.ordinal());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_186855_b(SERVANT_OWNER_ID)) {
            this.ownerId = nbt.func_186857_a(SERVANT_OWNER_ID);
        }
        if (nbt.func_150297_b(CASTER_TYPE, 2)) {
            this.casterType = CasterType.byId(nbt.func_74765_d(CASTER_TYPE));
        }
    }

    public static enum CasterType {
        NONE,
        LIGHTNING,
        DARKNESS,
        FIRE,
        FROST,
        EARTH;


        public static CasterType getDefault() {
            return NONE;
        }

        public static CasterType byId(int id) {
            return id >= 0 && id < CasterType.values().length ? CasterType.values()[id] : CasterType.getDefault();
        }

        public static int getRandomId() {
            return Helper.RANDOM.nextInt(CasterType.values().length - 1) + 1;
        }

        public static CasterType getRandom() {
            return CasterType.byId(CasterType.getRandomId());
        }
    }
}

