/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.api.capability.IServantEntity;

public final class ServantEntityProvider
implements ICapabilitySerializable<CompoundNBT> {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "cap_servant_entity");
    @CapabilityInject(value=IServantEntity.class)
    public static final Capability<IServantEntity> SERVANT_ENTITY_CAPABILITY = (Capability)TombstoneAPIProps.unsafeNullCast();
    private final LazyOptional<IServantEntity> holderCap;

    public ServantEntityProvider(NonNullSupplier<IServantEntity> nonNullSupplier) {
        this.holderCap = LazyOptional.of(nonNullSupplier);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return SERVANT_ENTITY_CAPABILITY.orEmpty(cap, this.holderCap);
    }

    public CompoundNBT serializeNBT() {
        return this.holderCap.map(cap -> Optional.ofNullable((CompoundNBT)SERVANT_ENTITY_CAPABILITY.writeNBT(cap, null)).orElse(new CompoundNBT())).orElse(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.holderCap.ifPresent(cap -> SERVANT_ENTITY_CAPABILITY.readNBT(cap, null, (INBT)nbt));
    }
}

