/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ISpellCaster;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.PacketHandler;

public class SpellCasterImpl
implements ISpellCaster {
    protected int castingTime = 0;
    protected int castingColor = -1;
    protected int spellCooldown = 0;
    protected Entity specialTarget = null;

    @Override
    public boolean isCasting() {
        return this.castingColor > -1;
    }

    @Override
    public void startCasting(MobEntity caster, int castingTime, int castingColor) {
        this.castingTime = castingTime;
        this.castingColor = castingColor;
        PacketHandler.sendToAllTrackingPlayers(new CMessageSpellCasting(caster.func_145782_y(), this.castingColor), (LivingEntity)caster);
        caster.func_184185_a(this.getCastingSoundEvent(), 1.0f, 1.0f);
    }

    @Override
    public void stopCasting(MobEntity caster) {
        this.castingTime = 0;
        this.castingColor = -1;
        this.specialTarget = null;
        this.setSpellCooldown();
        PacketHandler.sendToAllTrackingPlayers(new CMessageSpellCasting(caster.func_145782_y(), this.castingColor), (LivingEntity)caster);
    }

    @Override
    public int getCastingColor() {
        return this.castingColor;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setCastingColor(int castingColor) {
        this.castingColor = castingColor;
    }

    @Override
    public boolean hasSpellCooldown() {
        return this.spellCooldown > 0;
    }

    @Override
    public void setSpellCooldown() {
        this.spellCooldown = 60;
    }

    @Override
    public Optional<Entity> getSpecialTarget() {
        return Optional.ofNullable(this.specialTarget);
    }

    @Override
    public void setSpecialTarget(@Nullable Entity specialTarget) {
        this.specialTarget = specialTarget;
    }

    @Override
    public void tick(MobEntity caster) {
        if (!caster.field_70170_p.func_201670_d()) {
            if (this.spellCooldown > 0) {
                --this.spellCooldown;
            } else if (this.castingTime > 0 && --this.castingTime == 0) {
                this.stopCasting(caster);
            }
        }
    }

    @Override
    public SoundEvent getCastingSoundEvent() {
        return SoundEvents.field_191244_bn;
    }
}

