/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModTriggers;

public final class TBCapabilityDefault
implements ITBCapability {
    private int knowledge = 0;
    private int alignment = 0;
    private int alignmentLevel = 0;
    private final Map<Perk, Integer> perks = new ConcurrentHashMap<Perk, Integer>();
    private static final String KNOWLEDGE_NBT_INT = "knowledge";
    private static final String ALIGNMENT_NBT_SHORT = "alignment";

    @Override
    public int getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(int points) {
        this.knowledge = Math.max(0, points);
    }

    @Override
    public void reward(ServerPlayerEntity player, int knowledge, int alignment) {
        if (EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            if (knowledge > 0) {
                int newPerkPoints;
                int earnedPerkPoints;
                int oldPerkPoints = this.getTotalPerkPoints();
                this.knowledge += knowledge;
                if (PlayerPreference.get((PlayerEntity)player).displayKnowledgeMessage()) {
                    LangKey.MESSAGE_EARN_KNOWLEDGE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), knowledge});
                }
                if ((earnedPerkPoints = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                    PacketHandler.sendToPlayer(new CMessageLevelUp(earnedPerkPoints), player);
                    if (oldPerkPoints == 0) {
                        ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                    }
                    if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                        ModTriggers.MASTERY_1.trigger(player);
                    }
                }
            }
            if (alignment != 0) {
                int oldAlignment = this.alignmentLevel;
                if (alignment > 0 && this.alignmentLevel < 0 || alignment < 0 && this.alignmentLevel > 0) {
                    alignment *= 2;
                }
                this.setAlignment(this.alignment + alignment);
                if (oldAlignment != this.alignmentLevel) {
                    this.onAlignmentLevelChange(oldAlignment, this.alignmentLevel);
                }
            }
            if (knowledge > 0 && alignment != 0) {
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.KNOWLEDGE_AND_ALIGNMENT, this.knowledge, this.alignment), player);
            } else if (knowledge > 0) {
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.KNOWLEDGE, this.knowledge), player);
            } else if (alignment != 0) {
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALIGNMENT, this.alignment), player);
            }
        }
    }

    @Override
    public void loseKnowledge(ServerPlayerEntity player, int points) {
        if (EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (PlayerEntity)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
            } else {
                PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.KNOWLEDGE, this.knowledge), player);
            }
            if (PlayerPreference.get((PlayerEntity)player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
            }
        }
    }

    @Override
    public int getKnowledgeForLevel(int level) {
        return level <= 0 ? 0 : level * level + 1;
    }

    @Override
    public void setAlignment(int value) {
        this.alignment = MathHelper.func_76125_a((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -500;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 500;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= this.getAlignmentMinValue()) {
            return -4;
        }
        if (this.alignment <= -300) {
            return -3;
        }
        if (this.alignment <= -150) {
            return -2;
        }
        if (this.alignment <= -50) {
            return -1;
        }
        if (this.alignment < 50) {
            return 0;
        }
        if (this.alignment < 150) {
            return 1;
        }
        if (this.alignment < 300) {
            return 2;
        }
        if (this.alignment < this.getAlignmentMaxValue()) {
            return 3;
        }
        return 4;
    }

    @Override
    public void onAlignmentLevelChange(int oldAlignment, int newAlignment) {
    }

    @Override
    public int getUsedPerkPoints(PlayerEntity player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += entry.getKey().getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)MathHelper.func_76129_c((float)(this.knowledge - 1));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public void setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
    }

    @Override
    public void removePerk(Perk perk) {
        this.perks.remove(perk);
    }

    @Override
    public int getPerkLevel(PlayerEntity player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(PlayerEntity player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public boolean canResetPerks(PlayerEntity player) {
        return CooldownHandler.INSTANCE.noCooldown(player, CooldownType.RESET_PERKS) && this.perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled(player));
    }

    @Override
    public boolean resetPerks(ServerPlayerEntity player) {
        if (EntityHelper.isValidServerPlayer((PlayerEntity)player) && this.canResetPerks((PlayerEntity)player)) {
            this.setPerks(new HashMap<Perk, Integer>());
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.RESET_PERKS);
            this.syncAll(player);
            return true;
        }
        return false;
    }

    @Override
    public void syncAll(ServerPlayerEntity player) {
        if (EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(KNOWLEDGE_NBT_INT, this.knowledge);
        nbt.func_74777_a(ALIGNMENT_NBT_SHORT, (short)this.alignment);
        NBTStackHelper.writePerks(this.perks, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b(KNOWLEDGE_NBT_INT, 3)) {
            this.knowledge = nbt.func_74762_e(KNOWLEDGE_NBT_INT);
        } else if (nbt.func_150297_b(KNOWLEDGE_NBT_INT, 4)) {
            this.knowledge = (int)nbt.func_74763_f(KNOWLEDGE_NBT_INT);
            nbt.func_82580_o(KNOWLEDGE_NBT_INT);
        }
        if (nbt.func_150297_b(ALIGNMENT_NBT_SHORT, 2)) {
            this.setAlignment(nbt.func_74765_d(ALIGNMENT_NBT_SHORT));
        } else if (nbt.func_150297_b(ALIGNMENT_NBT_SHORT, 3)) {
            this.setAlignment(nbt.func_74762_e(ALIGNMENT_NBT_SHORT));
            nbt.func_82580_o(ALIGNMENT_NBT_SHORT);
        }
        NBTStackHelper.readPerks(this.perks, nbt);
    }
}

