/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.IntStream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.PacketHandler;

public class CommandTBKnowledge
extends TombstoneCommand {
    private final SuggestionProvider<CommandSource> ALIGNMENT_SUGGESTION = (ctx, build) -> ISuggestionProvider.func_197013_a(IntStream.rangeClosed(-4, 4).mapToObj(String::valueOf), (SuggestionsBuilder)build);

    public CommandTBKnowledge(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbknowledge";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(this::showUsage);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(this::showKnowledge)).then(SubCommand.SHOW.literal().executes(this::showKnowledge))).then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(this::showUsage)).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::setKnowledge)))).then(((LiteralArgumentBuilder)SubCommand.GIVE.literal().executes(this::showUsage)).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::giveKnowledge)))).then(((LiteralArgumentBuilder)SubCommand.REMOVE.literal().executes(this::showUsage)).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::removeKnowledge)))).then(SubCommand.RESET_ANKH.literal().executes(this::resetAnkhCooldown))).then(((LiteralArgumentBuilder)SubCommand.ALIGNMENT.literal().executes(this::showUsage)).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-4, (int)4)).suggests(this.ALIGNMENT_SUGGESTION).executes(this::setAlignment))));
        return builder;
    }

    private int showKnowledge(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"player");
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> this.sendMessage((CommandSource)ctx.getSource(), LangKey.MESSAGE_SHOW_KNOWLEDGE.getText(StyleType.MESSAGE_SPELL, new Object[]{target.func_200200_C_(), cap.getKnowledge()}), false));
        return 1;
    }

    private int setKnowledge(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"player");
        int newKnowledge = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (newKnowledge < 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        int oldKnowledge = target.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getKnowledge).orElse(0);
        int adjust = newKnowledge - oldKnowledge;
        if (adjust >= 0) {
            this.increaseKnowledge((CommandSource)ctx.getSource(), target, adjust);
        } else {
            this.decreaseKnowledge((CommandSource)ctx.getSource(), target, Math.abs(adjust));
        }
        return 1;
    }

    private int giveKnowledge(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        this.increaseKnowledge((CommandSource)ctx.getSource(), target, amount);
        return 1;
    }

    private int removeKnowledge(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        this.decreaseKnowledge((CommandSource)ctx.getSource(), target, amount);
        return 1;
    }

    private void increaseKnowledge(CommandSource source, ServerPlayerEntity target, int amount) {
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(target, amount, 0));
        if (!target.equals((Object)source.func_197022_f()) || !PlayerPreference.get((PlayerEntity)target).displayKnowledgeMessage()) {
            this.sendMessage(source, LangKey.MESSAGE_EARN_KNOWLEDGE.getText(LangKey.MESSAGE_PLAYER_KNOWLEDGE.getText(target.func_200200_C_()), amount), false);
        }
    }

    private void decreaseKnowledge(CommandSource source, ServerPlayerEntity target, int amount) {
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.loseKnowledge(target, amount));
        if (!target.equals((Object)source.func_197022_f()) || !PlayerPreference.get((PlayerEntity)target).displayKnowledgeMessage()) {
            this.sendMessage(source, LangKey.MESSAGE_LOSE_KNOWLEDGE.getText(StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_PLAYER_KNOWLEDGE.getText(target.func_200200_C_()), amount}), false);
        }
    }

    private int resetAnkhCooldown(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"player");
        CooldownHandler.INSTANCE.setCooldown(target, CooldownType.NEXT_PRAY, 0);
        this.sendMessage((CommandSource)ctx.getSource(), LangKey.MESSAGE_RESET_ANKH.getText(StyleType.MESSAGE_SPELL, new Object[]{target.func_200200_C_()}), false);
        return 1;
    }

    private int setAlignment(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"player");
        int alignment = (new int[]{-500, -300, -150, -50, 0, 50, 150, 300, 500})[MathHelper.func_76125_a((int)IntegerArgumentType.getInteger(ctx, (String)"amount"), (int)-4, (int)4) + 4];
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.setAlignment(alignment));
        PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALIGNMENT, alignment), target);
        this.sendMessage((CommandSource)ctx.getSource(), LangKey.MESSAGE_SET_ALIGNMENT.getText(target.func_200200_C_()), false);
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        GIVE,
        REMOVE,
        RESET_ANKH,
        ALIGNMENT;

    }
}

