/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class CommandTBRestoreInventory
extends TombstoneCommand {
    public CommandTBRestoreInventory(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbrestoreinventory";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::restoreInventory)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(this::restoreInventory));
    }

    private int restoreInventory(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = CommandTBRestoreInventory.getPlayerOrCommandSender(ctx, "player");
        CommandTBRestoreInventory.checkAlive((Entity)target);
        CommandTBRestoreInventory.checkNotSpectator((Entity)target);
        boolean success = false;
        List<Location> graveLocations = DeathHandler.INSTANCE.getGraveList(target);
        for (Location lastGrave : graveLocations) {
            if (!this.restoreGrave(((CommandSource)ctx.getSource()).func_197028_i(), target, lastGrave)) continue;
            success = true;
        }
        if (this.restoreGrave(((CommandSource)ctx.getSource()).func_197028_i(), target, ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((PlayerEntity)target, ModItems.grave_key)))) {
            success = true;
        }
        if (!success) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        LangKey.MESSAGE_RECOVER_LOST_ITEMS.sendMessage((PlayerEntity)target, StyleType.MESSAGE_SPELL, new Object[0]);
        return 1;
    }

    private boolean restoreGrave(MinecraftServer server, ServerPlayerEntity player, Location loc) {
        ServerWorld currentWorld;
        if (!loc.isOrigin() && (currentWorld = server.func_71218_a(loc.dim)) != null) {
            TileEntity tile = currentWorld.func_175625_s(loc.getPos());
            if (tile instanceof TileEntityPlayerGrave) {
                TileEntityPlayerGrave grave = (TileEntityPlayerGrave)tile;
                ModItems.grave_key.removeKeyForGraveInInventory((PlayerEntity)player, grave);
                grave.giveInventory(player);
                return true;
            }
            DeathHandler.INSTANCE.removeGrave(player, loc);
        }
        return false;
    }
}

