/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CompatibilityCurio {
    public static final CompatibilityCurio instance = new CompatibilityCurio();
    public final ResourceLocation MAGIC_BOOK_SLOT = new ResourceLocation("curios", "item/magic_book_slot");
    @CapabilityInject(value=ICuriosItemHandler.class)
    public static final Capability<ICuriosItemHandler> INVENTORY = (Capability)Helper.unsafeNullCast();
    @CapabilityInject(value=ICurio.class)
    public static final Capability<ICurio> ITEM = (Capability)Helper.unsafeNullCast();

    private CompatibilityCurio() {
    }

    public void autoEquip(ServerPlayerEntity player, ItemStackHandler itemHandler, List<Integer> ids) {
        if (INVENTORY == null || ITEM == null) {
            return;
        }
        Map map = player.getCapability(INVENTORY).resolve().map(ICuriosItemHandler::getCurios).orElse(null);
        if (map == null) {
            return;
        }
        ListIterator<Integer> idIterator = ids.listIterator(ids.size());
        block0: while (idIterator.hasPrevious()) {
            int slotId = idIterator.previous();
            ItemStack stack = itemHandler.getStackInSlot(slotId);
            Set tags = CuriosApi.getCuriosHelper().getCurioTags(stack.func_77973_b());
            ListIterator tagIterator = new ArrayList(map.keySet()).listIterator(map.keySet().size());
            while (tagIterator.hasPrevious()) {
                ICurioStacksHandler curioStacksHandler;
                String tag = (String)tagIterator.previous();
                if (tag.equals("magic_book") && !PlayerPreference.get((PlayerEntity)player).equipCurioSlotMagicBook() || !tags.contains(tag) || (curioStacksHandler = (ICurioStacksHandler)map.get(tag)) == null || !this.autoEquip(curioStacksHandler, stack)) continue;
                itemHandler.setStackInSlot(slotId, ItemStack.field_190927_a);
                idIterator.remove();
                continue block0;
            }
        }
    }

    private boolean autoEquip(ICurioStacksHandler curioStacksHandler, ItemStack stack) {
        IDynamicStackHandler dynamicStacks = curioStacksHandler.getStacks();
        for (int i = curioStacksHandler.getSlots() - 1; i >= 0; --i) {
            if (!dynamicStacks.getStackInSlot(i).func_190926_b() || !dynamicStacks.isItemValid(i, stack)) continue;
            dynamicStacks.setStackInSlot(i, stack.func_77946_l());
            return true;
        }
        return false;
    }

    public void sendIMC() {
        if (((Boolean)ConfigTombstone.compatibility.curioMagicBookSupport.get()).booleanValue()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("magic_book").icon(this.MAGIC_BOOK_SLOT).size(1).build());
        }
    }

    public ItemStack getStackInMagicBookSlot(PlayerEntity player) {
        return INVENTORY == null || ITEM == null ? ItemStack.field_190927_a : player.getCapability(INVENTORY).resolve().flatMap(i -> i.getStacksHandler("magic_book")).map(handler -> handler.getStacks().getStackInSlot(0)).orElse(ItemStack.field_190927_a);
    }
}

