/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class IntegrationTOP
implements Function<ITheOneProbe, Void> {
    private static final String RL = "tombstone:top";
    private static final Map<Block, List<IElement>> ELEMENTS = new HashMap<Block, List<IElement>>();
    private static boolean FAILED = false;

    private void setElements(BlockGrave grave, IProbeInfo probeInfo) {
        List oldElements = probeInfo.getElements();
        List<IElement> cache = ELEMENTS.get((Object)grave);
        if (cache == null) {
            ItemStack stack = grave.asDecorativeStack();
            if (!stack.func_190926_b()) {
                ArrayList toKeep = oldElements.size() == 1 ? new ArrayList() : IntStream.range(1, oldElements.size()).mapToObj(oldElements::get).collect(Collectors.toList());
                oldElements.clear();
                ILayoutStyle layout = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT).spacing(2);
                probeInfo.horizontal(layout).item(stack).vertical(layout).itemLabel(stack).text(TextFormatting.BLUE.toString() + TextFormatting.ITALIC + "Corail Tombstone");
                probeInfo.getElements().addAll(toKeep);
                ELEMENTS.put((Block)grave, new ArrayList(probeInfo.getElements()));
            }
        } else {
            oldElements.clear();
            oldElements.addAll(cache);
        }
    }

    @Override
    public Void apply(ITheOneProbe probe) {
        ModTombstone.LOGGER.info("Integration TOP");
        try {
            probe.registerProvider((probeMode, iProbeInfo, player, level, blockState, iProbeHitData) -> {
                if (FAILED || level.func_201670_d()) {
                    return;
                }
                if (ModBlocks.isPlayerGrave(blockState.func_177230_c())) {
                    try {
                        this.setElements((BlockGrave)blockState.func_177230_c(), iProbeInfo);
                        TileEntity tile = level.func_175625_s(iProbeHitData.getPos());
                        if (tile instanceof TileEntityPlayerGrave) {
                            TileEntityPlayerGrave grave = (TileEntityPlayerGrave)tile;
                            iProbeInfo.text(grave.getFormattedInfo());
                            iProbeInfo.text(grave.getFormattedDeathDate());
                        }
                    }
                    catch (Throwable t) {
                        ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
                        FAILED = true;
                    }
                }
            });
        }
        catch (Throwable t) {
            ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
            FAILED = true;
        }
        return null;
    }

    static interface GraveInfoProvider
    extends IProbeInfoProvider {
        default public String getID() {
            return IntegrationTOP.RL;
        }
    }
}

