/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public class EnchantmentBlessing
extends ArmorEnchantment {
    private static final String BLESSING_LAST_PROC_NBT_LONG = "blessing_last_proc";

    public EnchantmentBlessing() {
        super("blessing", Enchantment.Rarity.RARE, EnchantmentType.ARMOR, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.HEAD, EquipmentSlotType.FEET);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentBlessing.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.blessingEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int amplifier) {
        int count = 0;
        int amplifierSum = 0;
        for (EquipmentSlotType slot : this.field_185263_a) {
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)wearer.func_184582_a(slot));
            if (lvl <= 0) continue;
            amplifierSum += lvl;
            if (++count == 4) break;
        }
        if (count > 0) {
            CompoundNBT persistantData = wearer.getPersistentData();
            boolean valid = !persistantData.func_150297_b(BLESSING_LAST_PROC_NBT_LONG, 4);
            int delay = TimeHelper.tickFromSecond(10);
            if (!valid) {
                long timeLeft = persistantData.func_74763_f(BLESSING_LAST_PROC_NBT_LONG) - (long)wearer.field_70173_aa;
                if (timeLeft < 0L) {
                    persistantData.func_82580_o(BLESSING_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.func_74772_a(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
                }
            }
            if (valid && wearer.func_70681_au().nextInt(10) < count) {
                int effectDuration;
                int effectAmplifier;
                int amplifierMean = amplifierSum / count;
                if (amplifierMean > 1) {
                    effectAmplifier = wearer.func_70681_au().nextInt(count + 1);
                    effectDuration = TimeHelper.tickFromSecond(30);
                } else {
                    effectAmplifier = 0;
                    effectDuration = TimeHelper.tickFromSecond(30 + amplifierMean * 3);
                }
                EffectHelper.addEffect(wearer, EffectHelper.getRandomEffect(effectDuration, false, true, i -> effectAmplifier));
                persistantData.func_74772_a(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
            }
        }
    }
}

