/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class EnchantmentSpectralBite
extends ArmorEnchantment {
    private static final String SPECTRAL_BITE_LAST_PROC_NBT_LONG = "spectral_bite_last_proc";

    public EnchantmentSpectralBite() {
        super("spectral_bite", Enchantment.Rarity.RARE, EnchantmentType.ARMOR_FEET, EquipmentSlotType.FEET);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentSpectralBite.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.spectralBiteEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int amplifier) {
        amplifier = EntityHelper.getSpectralBiteLevel(wearer);
        if (amplifier > 0) {
            boolean valid;
            double scale = (double)amplifier / (double)this.func_77325_b();
            int delay = TimeHelper.tickFromSecond(30 - (int)(scale * 27.0));
            CompoundNBT persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.func_150297_b(SPECTRAL_BITE_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.func_74763_f(SPECTRAL_BITE_LAST_PROC_NBT_LONG) - (long)wearer.field_70173_aa;
                if (timeLeft <= 0L) {
                    persistantData.func_82580_o(SPECTRAL_BITE_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.func_74772_a(SPECTRAL_BITE_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
                }
            }
            if (valid && wearer.func_70681_au().nextInt(Math.max(10, this.func_77325_b())) < amplifier) {
                Helper.castSpectralBite(wearer, attacker, true);
                persistantData.func_74772_a(SPECTRAL_BITE_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
            }
        }
    }

    @Override
    public boolean isInBeta() {
        return true;
    }
}

