/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.Trades;
import ovh.corail.tombstone.entity.ai.LookAtTradingPlayerGoal;
import ovh.corail.tombstone.entity.ai.TradeWithPlayerGoal;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public abstract class AbstractMerchant
extends CreatureEntity
implements IMerchant {
    private static final DataParameter<Byte> TRADE_LEVEL = EntityDataManager.func_187226_a(AbstractMerchant.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TRADE_XP = EntityDataManager.func_187226_a(AbstractMerchant.class, (IDataSerializer)DataSerializers.field_187192_b);
    @Nullable
    protected PlayerEntity tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    protected long lastRestockGameTime = -1L;
    private static final int UPDATE_VERSION = 3;

    protected AbstractMerchant(EntityType<? extends AbstractMerchant> merchant, World level) {
        super(merchant, level);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRADE_LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(TRADE_XP, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, new TradeWithPlayerGoal<AbstractMerchant>(this));
        this.field_70714_bg.func_75776_a(1, new LookAtTradingPlayerGoal<AbstractMerchant>(this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.tradingPlayer;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.initTrades();
        }
        return this.offers;
    }

    private void initTrades() {
        this.offers = new MerchantOffers();
        int tradeLevel = this.getTradeLevel();
        this.addBasicTrades(TradeType.COMMON, tradeLevel + 4);
        if (tradeLevel > 1) {
            this.addBasicTrades(TradeType.UNCOMMON, tradeLevel + 2);
        }
        if (tradeLevel > 3) {
            this.addBasicTrades(TradeType.RARE, tradeLevel);
        }
        if (TimeHelper.isDateAroundHalloween()) {
            this.addHalloweenTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addHalloweenTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addHalloweenTrades(TradeType.RARE);
            }
        }
        if (TimeHelper.isDateAroundChristmas()) {
            this.addChristmasTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addChristmasTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addChristmasTrades(TradeType.RARE);
            }
        }
        EventFactory.onInitGraveGuardianOffers(this);
    }

    private void addBasicTrades(TradeType tradeType, int toAdd) {
        Optional.of(tradeType.getBasicTrades()).filter(trades -> ((VillagerTrades.ITrade[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ITrade[])trades, toAdd));
    }

    private void addHalloweenTrades(TradeType tradeType) {
        Optional.of(tradeType.getHalloweenTrades()).filter(trades -> ((VillagerTrades.ITrade[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ITrade[])trades, ((VillagerTrades.ITrade[])trades).length));
    }

    private void addChristmasTrades(TradeType tradeType) {
        Optional.of(tradeType.getChristmasTrades()).filter(trades -> ((VillagerTrades.ITrade[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ITrade[])trades, ((VillagerTrades.ITrade[])trades).length));
    }

    private void addTrades(VillagerTrades.ITrade[] trades, int toAdd) {
        if (toAdd >= trades.length) {
            Arrays.stream(trades).map(trade -> trade.func_221182_a((Entity)this, this.field_70146_Z)).filter(Objects::nonNull).forEach(arg_0 -> this.func_213706_dY().add(arg_0));
        } else {
            List ids = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
            Collections.shuffle(ids, this.field_70146_Z);
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                MerchantOffer offer = trades[id].func_221182_a((Entity)this, this.field_70146_Z);
                if (offer == null) continue;
                this.func_213706_dY().add((Object)offer);
                if (--toAdd > 0) continue;
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(@Nullable MerchantOffers offers) {
        this.offers = offers;
    }

    public void func_213702_q(int xp) {
        this.setVillagerXp(xp);
        this.increaseLevel(0);
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187866_fi : SoundEvents.field_187868_fj, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        if (EntityHelper.isValidServerPlayer(this.tradingPlayer)) {
            boolean isFirstSlot;
            ServerPlayerEntity player = (ServerPlayerEntity)this.tradingPlayer;
            assert (player != null);
            ModTriggers.TRADE_GRAVE_GUARDIAN.trigger(player);
            boolean bl = isFirstSlot = offer.func_222218_a().func_77973_b() == ModItems.lollipop;
            if (isFirstSlot || offer.func_222202_c().func_77973_b() == ModItems.lollipop) {
                ModTriggers.TRADE_LOLLIPOP.trigger(player, (isFirstSlot ? offer.func_222218_a() : offer.func_222202_c()).func_190916_E());
                if (offer.func_222200_d().func_77973_b() == ModItems.essence_of_undeath) {
                    ModTriggers.TRADE_LOLLIPOP_FOR_ESSENCE.trigger(player);
                }
            }
        }
        this.field_70757_a = -this.func_70627_aG();
        boolean isLevelUp = this.increaseLevel(offer.func_222210_n());
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), (isLevelUp ? 20 : 0) + this.field_70146_Z.nextInt(offer.func_222210_n()) + offer.func_222210_n()));
        }
    }

    private boolean increaseLevel(int offerXp) {
        int traderLevel = this.getTradeLevel();
        this.setVillagerXp(this.func_213708_dV() + offerXp);
        if (traderLevel < 5 && this.func_213708_dV() >= VillagerData.func_221127_c((int)traderLevel)) {
            this.setTradeLevel(traderLevel + 1);
            this.initTrades();
            Optional.ofNullable(this.func_70931_l_()).ifPresent(player -> player.func_213818_a(player.field_71070_bA.field_75152_c, this.func_213706_dY(), traderLevel + 1, this.func_213708_dV(), this.func_213705_dZ(), this.func_223340_ej()));
            return true;
        }
        return false;
    }

    @Nullable
    public Entity changeDimension(ServerWorld level, ITeleporter teleporter) {
        this.func_70932_a_(null);
        return super.changeDimension(level, teleporter);
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.func_70932_a_(null);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.func_70089_S() && this.tradingPlayer == null) {
            if (hand == Hand.MAIN_HAND && EntityHelper.isValidServerPlayer(player)) {
                ModTriggers.TALK_GRAVE_GUARDIAN.trigger((ServerPlayerEntity)player);
            }
            if (!(this.field_70170_p.field_72995_K || this.func_213706_dY().isEmpty() || EntityHelper.targetAnEnemy((LivingEntity)this))) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), this.getTradeLevel());
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public int func_213708_dV() {
        return (Integer)this.field_70180_af.func_187225_a(TRADE_XP);
    }

    public void setVillagerXp(int tradeXp) {
        this.field_70180_af.func_187227_b(TRADE_XP, (Object)tradeXp);
    }

    public int getTradeLevel() {
        return (Byte)this.field_70180_af.func_187225_a(TRADE_LEVEL) & 0xFF;
    }

    public void setTradeLevel(int tradeLevel) {
        this.field_70180_af.func_187227_b(TRADE_LEVEL, (Object)((byte)tradeLevel));
    }

    public boolean func_213705_dZ() {
        return true;
    }

    public boolean func_223340_ej() {
        return true;
    }

    public void restock() {
        for (MerchantOffer offer : this.func_213706_dY()) {
            boolean hasImpregnatedDiamondB;
            boolean hasImpregnatedDiamondA = offer.func_222218_a().func_77973_b() == ModItems.impregnated_diamond;
            boolean bl = hasImpregnatedDiamondB = offer.func_222202_c().func_77973_b() == ModItems.impregnated_diamond;
            if ((hasImpregnatedDiamondA || hasImpregnatedDiamondB) && (offer.func_222213_g() > 0 || this.field_70146_Z.nextInt(31) == 0)) {
                if (hasImpregnatedDiamondA) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.func_222218_a());
                }
                if (hasImpregnatedDiamondB) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.func_222202_c());
                }
            }
            if (offer.func_222218_a().func_77973_b() == ModItems.lollipop && this.field_70146_Z.nextInt(31) == 0) {
                ModItems.lollipop.resetColor(offer.func_222218_a());
            }
            offer.func_222203_h();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d() && this.tradingPlayer == null && this.func_223340_ej()) {
            long worldTicks = TimeHelper.worldTicks(this.field_70170_p);
            if (this.lastRestockGameTime < 0L || this.lastRestockGameTime > worldTicks) {
                this.lastRestockGameTime = worldTicks;
            } else if (worldTicks - this.lastRestockGameTime >= (long)TimeHelper.tickFromMinute(Math.max(1, (Integer)ConfigTombstone.decorative_grave.restockTimeGraveGuardian.get()))) {
                this.lastRestockGameTime = worldTicks;
                this.restock();
            }
        }
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_190035_gx;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("special_event", (short)TimeHelper.getSpecialEvent().ordinal());
        compound.func_74777_a("update_version", (short)3);
        MerchantOffers offers = this.func_213706_dY();
        if (!offers.isEmpty()) {
            compound.func_218657_a("Offers", (INBT)offers.func_222199_a());
        }
        compound.func_74774_a("trade_level", ((Byte)this.field_70180_af.func_187225_a(TRADE_LEVEL)).byteValue());
        compound.func_74768_a("trade_xp", this.func_213708_dV());
        compound.func_74772_a("last_restock", this.lastRestockGameTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.loadOffers(compound);
        if (compound.func_150297_b("trade_level", 1)) {
            this.setTradeLevel(compound.func_74771_c("trade_level") & 0xFF);
        }
        if (compound.func_150297_b("trade_xp", 3)) {
            this.setVillagerXp(compound.func_74762_e("trade_xp"));
        }
        if (compound.func_150297_b("last_restock", 4)) {
            this.lastRestockGameTime = compound.func_74763_f("last_restock");
        }
    }

    private void loadOffers(CompoundNBT compound) {
        if (compound.func_150297_b("special_event", 2) && TimeHelper.getSpecialEvent() != TimeHelper.SpecialEvent.byId(compound.func_74765_d("special_event"))) {
            this.offers = null;
        } else if (compound.func_150297_b("update_version", 2) && 3 != compound.func_74765_d("update_version")) {
            this.offers = null;
        } else if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
            for (MerchantOffer offer : this.offers) {
                ItemStack buy2;
                ItemStack buy1 = offer.func_222218_a();
                if (buy1.func_77973_b() instanceof IDisableable && !((IDisableable)buy1.func_77973_b()).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (buy1.func_77973_b() == ModItems.impregnated_diamond && ModItems.impregnated_diamond.getEntityType(buy1).isEmpty()) {
                    ModItems.impregnated_diamond.withRandomImpregnation(buy1);
                }
                if ((buy2 = offer.func_222202_c()).func_77973_b() instanceof IDisableable && !((IDisableable)buy2.func_77973_b()).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (buy2.func_77973_b() != ModItems.impregnated_diamond || !ModItems.impregnated_diamond.getEntityType(buy2).isEmpty()) continue;
                ModItems.impregnated_diamond.withRandomImpregnation(buy2);
            }
        }
    }

    private static enum TradeType {
        COMMON,
        UNCOMMON,
        RARE;


        private VillagerTrades.ITrade[] getBasicTrades() {
            return (VillagerTrades.ITrade[])Trades.TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ITrade[] getHalloweenTrades() {
            return (VillagerTrades.ITrade[])Trades.HALLOWEEN_TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ITrade[] getChristmasTrades() {
            return (VillagerTrades.ITrade[])Trades.CHRISTMAS_TRADES.get(this.ordinal() + 1);
        }
    }
}

