/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public abstract class FollowOwnerGoal
extends Goal {
    public final MobEntity mob;
    private PlayerEntity owner;
    private final IWorldReader level;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;
    private final double teleportDistance;

    public FollowOwnerGoal(MobEntity mob, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.mob = mob;
        this.level = mob.field_70170_p;
        this.speedModifier = speedModifier;
        this.navigation = mob.func_70661_as();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.teleportDistance = (double)(this.startDistance * this.startDistance) * 2.0;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_75250_a() {
        if (this.mob.func_110167_bD()) {
            return false;
        }
        this.owner = this.getOwner().orElse(null);
        if (this.owner == null) return false;
        if (!this.owner.field_70170_p.func_234923_W_().equals(this.mob.field_70170_p.func_234923_W_())) return false;
        if (this.owner.func_175149_v()) return false;
        double d = this.mob.func_70068_e((Entity)this.owner);
        double d2 = this.startDistance * this.startDistance;
        double d3 = this.mob.func_70638_az() != null && this.mob.func_70638_az().func_70089_S() ? 4.0 : 1.0;
        if (!(d >= d2 * d3)) return false;
        return true;
    }

    public boolean func_75253_b() {
        return !this.mob.func_110167_bD() && !this.navigation.func_75500_f() && this.mob.func_70068_e((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.func_184643_a(PathNodeType.WATER);
        this.mob.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigation.func_75499_g();
        this.mob.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.mob.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.mob.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.mob.func_110167_bD() && !this.mob.func_184218_aH()) {
                if (this.requireTeleport()) {
                    this.teleportToOwner();
                } else {
                    this.navigation.func_75497_a((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            if (!this.maybeTeleportTo(blockpos.func_177958_n() + this.randomIntInclusive(-3, 3), blockpos.func_177956_o() + this.randomIntInclusive(-1, 1), blockpos.func_177952_p() + this.randomIntInclusive(-3, 3))) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.mob.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, this.mob.field_70177_z, this.mob.field_70125_A);
        this.navigation.func_75499_g();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathNodeType blockpathtypes = WalkNodeProcessor.func_237231_a_((IBlockReader)this.level, (BlockPos.Mutable)pos.func_239590_i_());
        if (blockpathtypes != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.func_180495_p(pos.func_177977_b());
        if (!this.canFly && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vector3i)this.mob.func_233580_cy_());
        return this.level.func_226665_a__((Entity)this.mob, this.mob.func_174813_aQ().func_186670_a(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.mob.func_70681_au().nextInt(max - min + 1) + min;
    }

    protected abstract Optional<PlayerEntity> getOwner();

    protected boolean requireTeleport() {
        return this.mob.func_70068_e((Entity)this.owner) >= this.teleportDistance * Optional.ofNullable(this.mob.func_70638_az()).filter(LivingEntity::func_70089_S).map(e -> 2.0).orElse(1.0);
    }
}

