/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTriggers;

public class WololoSpellGoal
extends SpellUseGoal {
    protected final DyeColor dyeColor;
    protected final EntityPredicate wololoTargeting;

    public WololoSpellGoal(CreatureEntity caster, DyeColor dyeColor) {
        super(caster);
        this.dyeColor = dyeColor;
        this.wololoTargeting = new EntityPredicate().func_221009_d().func_221008_a().func_221013_a(16.0).func_221012_a(e -> ((SheepEntity)e).func_175509_cj() != this.dyeColor);
    }

    @Override
    public boolean func_75250_a() {
        List list;
        if (super.func_75250_a() && this.caster.func_70638_az() == null && !(list = this.caster.field_70170_p.func_217374_a(SheepEntity.class, this.wololoTargeting, (LivingEntity)this.caster, this.caster.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0))).isEmpty()) {
            EntityHelper.setSpecialTargetForSpell(this.caster, (Entity)list.get(Helper.RANDOM.nextInt(list.size())));
            return true;
        }
        return false;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.caster.func_70638_az() == null;
    }

    @Override
    protected void performSpellCasting() {
        EntityHelper.getSpecialTargetForSpell(this.caster).filter(SheepEntity.class::isInstance).map(SheepEntity.class::cast).ifPresent(sheep -> {
            sheep.func_175512_b(this.dyeColor);
            EntityHelper.getServantOwner((Entity)this.caster).ifPresent(owner -> ModTriggers.WOLOLO.get(this.dyeColor).trigger((ServerPlayerEntity)owner));
        });
    }

    @Override
    protected int getCastWarmupTime() {
        return 80;
    }

    @Override
    protected int getCastingTime() {
        return 100;
    }

    @Override
    protected int getCastingInterval() {
        return 400;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.field_191249_bs;
    }

    @Override
    protected int getSpellColor() {
        return 3178592;
    }
}

