/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.List;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import ovh.corail.tombstone.gui.ColorOptionSlider;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.helper.StyleType;

public class ColorSliderHandler
implements ScreenConfig.IHideable {
    private final ITextComponent title;
    private final ITextComponent info;
    private int r;
    private int g;
    private int b;
    private final BooleanConsumer dirty;
    private ColorOptionSlider button1;
    private ColorOptionSlider button2;
    private ColorOptionSlider button3;

    ColorSliderHandler(String title, int color, BooleanConsumer dirty) {
        this.title = new TranslationTextComponent("tombstone.config." + title);
        this.info = new TranslationTextComponent("tombstone.config." + title + ".tooltip").func_230530_a_(StyleType.TOOLTIP_DESC);
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.dirty = dirty;
    }

    private int getMinColorR() {
        return this.g * 256 + this.b;
    }

    private int getMaxColorR() {
        return this.getMinColorR() + 0xFF0000;
    }

    private int getMinColorG() {
        return this.r * 65536 + this.b;
    }

    private int getMaxColorG() {
        return this.getMinColorG() + 65280;
    }

    private int getMinColorB() {
        return this.r * 65536 + this.g * 256;
    }

    private int getMaxColorB() {
        return this.getMinColorB() + 255;
    }

    public int getColor() {
        return 65536 * this.r + 256 * this.g + this.b;
    }

    ITextComponent getTitle() {
        return this.title;
    }

    ITextComponent getInfo() {
        return this.info;
    }

    public void createWidget(GameSettings settings, List<Widget> list, List<IGuiEventListener> children, int x, int y, int width, int height) {
        this.button1 = new ColorOptionSlider(settings, x, y, width, height, new SliderPercentageOption(this.title + "_R", 0.0, 255.0, 1.0f, s -> this.r, (s, d) -> {
            this.r = d.intValue();
        }, (s, d) -> new StringTextComponent(this.title + "_R")), this::getMinColorR, this::getMaxColorR, this.dirty);
        list.add((Widget)this.button1);
        children.add((IGuiEventListener)this.button1);
        this.button2 = new ColorOptionSlider(settings, x, y + 6, width, height, new SliderPercentageOption(this.title + "_G", 0.0, 255.0, 1.0f, s -> this.g, (s, d) -> {
            this.g = d.intValue();
        }, (s, d) -> new StringTextComponent(this.title + "_G")), this::getMinColorG, this::getMaxColorG, this.dirty);
        list.add((Widget)this.button2);
        children.add((IGuiEventListener)this.button2);
        this.button3 = new ColorOptionSlider(settings, x, y + 12, width, height, new SliderPercentageOption(this.title + "_B", 0.0, 255.0, 1.0f, s -> this.b, (s, d) -> {
            this.b = d.intValue();
        }, (s, d) -> new StringTextComponent(this.title + "_B")), this::getMinColorB, this::getMaxColorB, this.dirty);
        list.add((Widget)this.button3);
        children.add((IGuiEventListener)this.button3);
    }

    @Override
    public void show() {
        this.button3.field_230694_p_ = true;
        this.button3.field_230693_o_ = true;
        this.button2.field_230694_p_ = true;
        this.button2.field_230693_o_ = true;
        this.button1.field_230694_p_ = true;
        this.button1.field_230693_o_ = true;
    }

    @Override
    public void hide() {
        this.button3.field_230694_p_ = false;
        this.button3.field_230693_o_ = false;
        this.button2.field_230694_p_ = false;
        this.button2.field_230693_o_ = false;
        this.button1.field_230694_p_ = false;
        this.button1.field_230693_o_ = false;
    }
}

