/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class Location
implements Comparable<Location> {
    public int x;
    public int y;
    public int z;
    public final RegistryKey<World> dim;
    static final BlockPos ORIGIN_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    public static final Location ORIGIN = new Location(ORIGIN_POS, (RegistryKey<World>)World.field_234918_g_);

    public Location(BlockPos pos, RegistryKey<World> dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public Location(BlockPos pos, World world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
    }

    public Location(int x, int y, int z, World world) {
        this(x, y, z, (RegistryKey<World>)world.func_234923_W_());
    }

    public Location(int x, int y, int z, RegistryKey<World> dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public Location(GlobalPos globalPos) {
        this(globalPos.func_218180_b(), (RegistryKey<World>)globalPos.func_239646_a_());
    }

    public Location(Entity entity) {
        this(entity.func_233580_cy_(), entity.field_70170_p);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public GlobalPos asGlobalPos() {
        return GlobalPos.func_239648_a_(this.dim, (BlockPos)this.getPos());
    }

    public Location move(Direction direction, int length) {
        Vector3i vec = direction.func_176730_m();
        this.x += vec.func_177958_n() * length;
        this.y += vec.func_177956_o() * length;
        this.z += vec.func_177952_p() * length;
        return this;
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public boolean isSameDimension(World world) {
        return this.dim.equals((Object)world.func_234923_W_());
    }

    public boolean isSameDimension(String worldRL) {
        return this.getDimString().equals(worldRL);
    }

    public double getDistanceSq(Location location) {
        return this.getDistanceSq(location.getPos());
    }

    public double getDistanceSq(BlockPos pos) {
        double d0 = this.x - pos.func_177958_n();
        double d1 = this.y - pos.func_177956_o();
        double d2 = this.z - pos.func_177952_p();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isInRangeAndDimension(Location loc, int range) {
        return this.isInRange(loc, range) && this.dim.equals(loc.dim);
    }

    public boolean isInRange(int x, int y, int z, int range) {
        return this.isInRange(new Location(x, y, z, this.dim), range);
    }

    public boolean isInRange(BlockPos position, int range) {
        return this.getDistanceSq(position) <= (double)(range * range);
    }

    public boolean isInRange(Location location, int range) {
        return this.getDistanceSq(location) <= (double)(range * range);
    }

    public String getDimString() {
        return this.dim.func_240901_a_().toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", (Object)this.getDimString()).toString();
    }

    @Override
    public int compareTo(Location location) {
        int compDim = this.dim.compareTo(location.dim);
        return compDim != 0 ? compDim : new Vector3i(this.x, this.y, this.z).compareTo(new Vector3i(location.x, location.y, location.z));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Location location = (Location)o;
            return this.x == location.x && this.y == location.y && this.z == location.z && this.dim.func_240901_a_().equals((Object)location.dim.func_240901_a_());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dim.func_240901_a_(), this.x, this.y, this.z);
    }
}

