/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.FishingPredicate;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.loot.CheckEnableFunction;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.IsHalloweenFunction;
import ovh.corail.tombstone.loot.RandomScrollBuffFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.mixin.accessor.LootTableAccessor;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModPotions;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootHelper {
    private static final List<LootTable> CHEST_TABLES = new ArrayList<LootTable>();
    private static final Map<UpdaterHandler.PoolType, LootTable> CUSTOM_LOOTTABLES = new ConcurrentHashMap<UpdaterHandler.PoolType, LootTable>();

    private static void addEntry(LootPool.Builder builder, Item item, int weight, LootFunction.Builder<?> ... functions) {
        StandaloneLootEntry.Builder lootBuilder = ItemLootEntry.func_216168_a((IItemProvider)item).func_216085_b(0).func_216086_a(weight);
        if (item instanceof IDisableable) {
            lootBuilder.func_212841_b_((ILootFunction.IBuilder)new CheckEnableFunction.Builder());
        }
        Arrays.stream(functions).forEach(arg_0 -> ((StandaloneLootEntry.Builder)lootBuilder).func_212841_b_(arg_0));
        builder.func_216045_a((LootEntry.Builder)lootBuilder);
    }

    private static void addEntry(LootPool.Builder builder, Item item, int weight, Consumer<CompoundNBT> consumer, LootFunction.Builder<?> ... functions) {
        StandaloneLootEntry.Builder lootBuilder = ItemLootEntry.func_216168_a((IItemProvider)item).func_216085_b(0).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), consumer))));
        if (item instanceof IDisableable) {
            lootBuilder.func_212841_b_((ILootFunction.IBuilder)new CheckEnableFunction.Builder());
        }
        Arrays.stream(functions).forEach(arg_0 -> ((StandaloneLootEntry.Builder)lootBuilder).func_212841_b_(arg_0));
        builder.func_216045_a((LootEntry.Builder)lootBuilder);
    }

    private static void addPotionEntry(LootPool.Builder builder, Potion potion, int weight) {
        LootHelper.addEntry(builder, Items.field_151068_bn, weight, (CompoundNBT tag) -> tag.func_74778_a("Potion", potion.getRegistryName().toString()), new LootFunction.Builder[0]);
    }

    private static void addRandomScrollBuffEntry(LootPool.Builder builder, boolean isAncient, int weight) {
        LootHelper.addEntry(builder, Items.field_190931_a, weight, new RandomScrollBuffFunction.Builder(isAncient));
    }

    private static void addEnchantedEntry(LootPool.Builder builder, Item item, int weight, LootFunction.Builder<?> ... functions) {
        LootHelper.addEntry(builder, item, weight, (CompoundNBT nbt) -> nbt.func_74757_a("enchant", true), functions);
    }

    private static void addAncientEntry(LootPool.Builder builder, ItemTablet item, int weight, LootFunction.Builder<?> ... functions) {
        LootHelper.addEntry(builder, (Item)item, weight, (CompoundNBT nbt) -> nbt.func_74757_a("ancient", true), functions);
    }

    private static void addEnchantedAncientEntry(LootPool.Builder builder, Item item, int weight, LootFunction.Builder<?> ... functions) {
        LootHelper.addEntry(builder, item, weight, (CompoundNBT nbt) -> {
            nbt.func_74757_a("enchant", true);
            nbt.func_74757_a("ancient", true);
        }, functions);
    }

    private static void addDelayedNBTEntry(LootPool.Builder builder, Item item, int weight) {
        LootHelper.addEntry(builder, item, weight, new DelayedNBTFunction.Builder());
    }

    private static LootPool getSeekerRodLootPool() {
        LootPool.Builder builder = LootPool.func_216096_a().name("tombstone:seeker_rod");
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 5, new LootFunction.Builder[0]);
        LootHelper.addEntry(builder, (Item)ModItems.soul_receptacle, 15, new LootFunction.Builder[0]);
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 25, new LootFunction.Builder[0]);
        LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 25);
        LootHelper.addPotionEntry(builder, ModPotions.restoration, 10);
        LootHelper.addRandomScrollBuffEntry(builder, true, 20);
        return builder.func_216044_b();
    }

    public static ItemStack getSeekerRodReward(ServerWorld level, BlockPos pos, PlayerEntity player) {
        LootContext lootParams = new LootContext.Builder(level).func_216023_a(player.func_70681_au()).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216022_a(LootParameterSets.field_216264_e);
        return LootHelper.getLootTable(UpdaterHandler.PoolType.SEEKER_ROD).func_216113_a(lootParams).stream().findFirst().orElse(new ItemStack((IItemProvider)Items.field_151153_ao));
    }

    public static LootPool getLostTreasureLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:lost_treasure").func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_234580_a_(FishingPredicate.func_234640_a_((boolean)true))));
        int weight = 0;
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 10, new LootFunction.Builder[0]);
        weight += 10;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 20, new LootFunction.Builder[0]);
        weight += 20;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_recall, 3, new LootFunction.Builder[0]);
        weight += 3;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_home, 3, new LootFunction.Builder[0]);
        weight += 3;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_assistance, 3, new LootFunction.Builder[0]);
        weight += 3;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20);
        weight += 20;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_cupidity, 3, new LootFunction.Builder[0]);
        weight += 3;
        LootHelper.addDelayedNBTEntry(builder, ModItems.magic_scroll, 50);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 10, new LootFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, (Item)ModItems.fishing_rod_of_misadventure, 20);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.lost_tablet, 100, new LootFunction.Builder[0]);
        if ((weight += 100) < 1000) {
            builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
        }
        return builder.func_216044_b();
    }

    public static LootPool getChestTreasureLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:chest_treasure");
        int weight = 0;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 20, new LootFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomScrollBuffEntry(builder, false, 100);
        weight += 100;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20);
        weight += 20;
        LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_cupidity, 10, new LootFunction.Builder[0]);
        weight += 10;
        LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_home, 10, new LootFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.magic_scroll, 50);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 10, new LootFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
        if ((weight += 10) < 1000) {
            builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
        }
        return builder.func_216044_b();
    }

    private static LootPool getCatMorningLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:cat_morning");
        LootHelper.addEntry(builder, (Item)ModItems.grave_dust, 100, new TriggerCatMorningFunction.Builder(), SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)));
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 1, new LootFunction.Builder[0]);
        int weight = 101;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 20, new LootFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 50, new LootFunction.Builder[0]);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.lollipop, 500, new IsHalloweenFunction.Builder(), new DelayedNBTFunction.Builder());
        builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - (weight += 500)));
        return builder.func_216044_b();
    }

    private static LootPool getUndeadMobLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:undead_mob");
        int weight = 0;
        LootHelper.addEntry(builder, (Item)ModItems.grave_dust, 100, SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)));
        weight += 100;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 10, new LootFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.magic_scroll, 20);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 5, new LootFunction.Builder[0]);
        if ((weight += 5) < 1000) {
            builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
        }
        return builder.func_216044_b();
    }

    private static LootPool getUndeadBossLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:undead_boss");
        int weight = 0;
        LootHelper.addEnchantedEntry(builder, ModItems.magic_scroll, 100, new DelayedNBTFunction.Builder());
        weight += 100;
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 20, new LootFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 20, new LootFunction.Builder[0]);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.soul_receptacle, 50, new LootFunction.Builder[0]);
        weight += 50;
        LootHelper.addRandomScrollBuffEntry(builder, true, 100);
        weight += 100;
        LootHelper.addEnchantedAncientEntry(builder, ModItems.magic_scroll, 50, new DelayedNBTFunction.Builder());
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.voodoo_poppet, 100, new DelayedNBTFunction.Builder());
        weight += 100;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_receptacle, 100, new DelayedNBTFunction.Builder());
        if ((weight += 100) < 1000) {
            builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(0).func_216086_a(1000 - weight));
        }
        return builder.func_216044_b();
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, ServerPlayerEntity player, DamageSource damageSource) {
        if (EntityHelper.isUndead(entity)) {
            LootContext.Builder builder = new LootContext.Builder(player.func_71121_q()).func_216023_a(entity.func_70681_au()).func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch()).func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_216283_c, (Object)damageSource).func_216021_b(LootParameters.field_216284_d, (Object)damageSource.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)damageSource.func_76364_f());
            if (entity.field_70717_bb != null) {
                builder = builder.func_216015_a(LootParameters.field_216282_b, (Object)entity.field_70717_bb);
            }
            LootContext context = builder.func_216022_a(LootParameterSets.field_216263_d);
            boolean isBoss = EntityHelper.isBoss(entity);
            UpdaterHandler.PoolType poolType = isBoss ? UpdaterHandler.PoolType.UNDEAD_BOSS : UpdaterHandler.PoolType.UNDEAD_MOB;
            int rolls = (isBoss ? 5 : 1) + (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.treasure_seeker) * 30 ? 1 : 0);
            IntStream.range(0, rolls).forEach(i -> {
                ItemStack stack = LootHelper.getLootTable(poolType).func_216113_a(context).stream().findFirst().orElse(ItemStack.field_190927_a);
                if (!stack.func_190926_b()) {
                    if (stack.func_77973_b() == ModItems.grave_dust) {
                        ModTriggers.GRAVE_DUST_FROM_UNDEAD.trigger(player);
                    }
                    drops.add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack));
                }
            });
        }
        if (TimeHelper.isDateAroundHalloween() && EntityHelper.isEnemy((Entity)entity) && Helper.RANDOM.nextInt(1000) < 50) {
            LootHelper.addDropToEntity(drops, entity, ModItems.lollipop.getRandomItemStack());
        }
    }

    public static LootTable getLootTable(UpdaterHandler.PoolType poolType) {
        return CUSTOM_LOOTTABLES.getOrDefault((Object)poolType, LootTable.field_186464_a);
    }

    private static void addDropToEntity(Collection<ItemEntity> drops, LivingEntity entity, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            drops.add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack));
        }
    }

    private static void attachLootPool(UpdaterHandler.PoolType poolType, LootTable lootTable) {
        LootPool lootPool = UpdaterHandler.instance.loadLootPool(poolType);
        if (lootPool == null) {
            lootPool = LootHelper.getDefaultLootPool(poolType);
            UpdaterHandler.instance.saveLootPool(poolType, lootPool);
        }
        ((LootTableAccessor)lootTable).getPools().add(lootPool);
    }

    private static LootPool getDefaultLootPool(UpdaterHandler.PoolType poolType) {
        switch (poolType) {
            case LOST_TREASURE: {
                return LootHelper.getLostTreasureLootPool();
            }
            case CAT_MORNING: {
                return LootHelper.getCatMorningLootPool();
            }
            case CHEST_TREASURE: {
                return LootHelper.getChestTreasureLootPool();
            }
            case UNDEAD_MOB: {
                return LootHelper.getUndeadMobLootPool();
            }
            case UNDEAD_BOSS: {
                return LootHelper.getUndeadBossLootPool();
            }
        }
        return LootHelper.getSeekerRodLootPool();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186388_am)) {
            CallbackHandler.addFastCallback(() -> {
                UpdaterHandler.PoolType[] poolTypes = new UpdaterHandler.PoolType[]{UpdaterHandler.PoolType.UNDEAD_MOB, UpdaterHandler.PoolType.UNDEAD_BOSS, UpdaterHandler.PoolType.SEEKER_ROD};
                for (UpdaterHandler.PoolType poolType : poolTypes) {
                    LootTable lootTable = LootTable.func_216119_b().func_216038_b();
                    lootTable.setLootTableId(new ResourceLocation("tombstone", poolType.getFilename()));
                    LootHelper.attachLootPool(poolType, lootTable);
                    CUSTOM_LOOTTABLES.put(poolType, lootTable);
                }
                LootHelper.attachLootPool(UpdaterHandler.PoolType.LOST_TREASURE, event.getTable());
                for (LootTable lootTable : CHEST_TABLES) {
                    LootHelper.attachLootPool(UpdaterHandler.PoolType.CHEST_TREASURE, lootTable);
                }
                CHEST_TABLES.clear();
                ModTombstone.LOGGER.debug("Updating LootTables");
            });
        } else if (event.getName().equals((Object)LootTables.field_215797_af)) {
            CallbackHandler.addFastCallback(() -> LootHelper.attachLootPool(UpdaterHandler.PoolType.CAT_MORNING, event.getTable()));
        } else if (Optional.of(event.getName()).map(rl -> !event.getName().equals((Object)LootTables.field_186420_b) && (rl.func_110624_b().equals("minecraft") ? rl.func_110623_a().startsWith("chests") && !rl.func_110623_a().startsWith("chests/village/") && !rl.func_110623_a().contains("supply") : rl.func_110623_a().contains("dungeon") || rl.func_110623_a().contains("treasure"))).orElse(false).booleanValue()) {
            CHEST_TABLES.add(event.getTable());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving().func_200600_R() != EntityType.field_200729_aH) {
            Optional.ofNullable(event.getSource()).filter(d -> EntityHelper.isValidServerPlayer(d.func_76346_g())).map(d -> (ServerPlayerEntity)d.func_76346_g()).ifPresent(player -> LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), player, event.getSource()));
        }
    }
}

