/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.compatibility.CompatibilityDruidCraft;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PrayerHelper;

public enum TameableType {
    TAMEABLE(e -> e instanceof TameableEntity, (player, entity) -> ((TameableEntity)entity).func_193101_c(player), entity -> ((TameableEntity)entity).func_184753_b(), (entity, tag) -> {}),
    HORSE(e -> e instanceof AbstractHorseEntity, (player, entity) -> ((AbstractHorseEntity)entity).func_110263_g(player), entity -> ((AbstractHorseEntity)entity).func_184780_dh(), (entity, tag) -> {
        if (entity instanceof AbstractChestedHorseEntity) {
            ((AbstractChestedHorseEntity)entity).func_110207_m(false);
        }
    }),
    FRIENDLY_ANIMAL(e -> e instanceof FoxEntity, (player, entity) -> entity.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).ifPresent(cap -> {
        UUID playerUUID = player.func_146103_bH().getId();
        ((FoxEntity)entity).func_213465_b(playerUUID);
        cap.setOwnerId(playerUUID);
        cap.setAI((CreatureEntity)entity);
    }), entity -> EntityHelper.getFriendlyOwnerId(entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            entity.func_184201_a(slot, ItemStack.field_190927_a);
        }
    }),
    DRUIDCRAFT(CompatibilityDruidCraft.instance::isTameable, CompatibilityDruidCraft.instance::setTameBy, CompatibilityDruidCraft.instance::getOwnerId, (entity, tag) -> tag.func_82580_o("OwnerUUID")),
    UNDEAD(PrayerHelper::isValidUndead, (player, entity) -> entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> {
        cap.setOwnerId(player.func_146103_bH().getId());
        cap.setAI((CreatureEntity)entity);
    }), entity -> EntityHelper.getServantOwnerId(entity).orElse(null), (entity, tag) -> {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            entity.func_184201_a(slot, ItemStack.field_190927_a);
        }
    });

    final Predicate<Entity> predic;
    final BiConsumer<PlayerEntity, Entity> tame;
    final Function<Entity, UUID> ownerId;
    final BiConsumer<Entity, CompoundNBT> onCapture;
    static final Map<String, TameableType> TAMEABLE_TYPE;
    static final Set<String> SUMMONABLE_TYPE;

    private TameableType(Predicate<Entity> predic, BiConsumer<PlayerEntity, Entity> tame, Function<Entity, UUID> ownerId, BiConsumer<Entity, CompoundNBT> onCapture) {
        this.predic = predic;
        this.tame = tame;
        this.ownerId = ownerId;
        this.onCapture = onCapture;
    }

    public static void init(World world) {
        if (!TAMEABLE_TYPE.isEmpty() || !SUMMONABLE_TYPE.isEmpty()) {
            return;
        }
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            String registryName = EntityHelper.getRegistryString(entityType);
            if (registryName.isEmpty()) continue;
            try {
                Entity entity = entityType.func_200721_a(world);
                if (entity == null) continue;
                Arrays.stream(TameableType.values()).filter(t -> t.predic.test(entity)).findFirst().ifPresent(tameable -> TAMEABLE_TYPE.put(registryName, (TameableType)((Object)tameable)));
                if (!entityType.func_200720_b() || !(entity instanceof MobEntity)) continue;
                SUMMONABLE_TYPE.add(registryName);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setTamedBy(PlayerEntity player, Entity entity) {
        Optional.ofNullable(TameableType.getType(entity)).ifPresent(t -> t.tame.accept(player, entity));
    }

    public static boolean isTamedBy(LivingEntity owner, Entity entity) {
        return Optional.ofNullable(TameableType.getType(entity)).map(t -> t.getOwnerId(entity)).map(id -> id.equals(owner.func_110124_au())).orElse(false);
    }

    @Nullable
    public UUID getOwnerId(Entity entity) {
        return this.ownerId.apply(entity);
    }

    public void onCapture(Entity entity, CompoundNBT tag) {
        this.onCapture.accept(entity, tag);
    }

    public static boolean isTameable(String entityTypeString) {
        return TameableType.getType(entityTypeString) != null;
    }

    @Nullable
    public static TameableType getType(@Nullable Entity entity) {
        return TameableType.getType(EntityHelper.getRegistryString(entity));
    }

    @Nullable
    public static TameableType getType(String entityTypeString) {
        return TAMEABLE_TYPE.get(entityTypeString);
    }

    public static String getRandomTameableEntityTypeString() {
        return Helper.getRandomInList(TAMEABLE_TYPE.keySet().stream().filter(type -> !Helper.containRL((List<String>)((List)ConfigTombstone.loot.unhandledTameableEntities.get()), type)).collect(Collectors.toList())).orElse("minecraft:cat");
    }

    public static String getRandomSummonableEntityTypeString() {
        return Helper.getRandomInList(SUMMONABLE_TYPE).orElse("minecraft:cat");
    }

    static {
        TAMEABLE_TYPE = new ConcurrentHashMap<String, TameableType>();
        SUMMONABLE_TYPE = ConcurrentHashMap.newKeySet();
    }
}

